/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.sift;

import java.util.ArrayList;
import java.util.Collection;
import net.semanticmetadata.lire.imageanalysis.sift.Model;
import net.semanticmetadata.lire.imageanalysis.sift.Point;

public class PointMatch {
    private final Point p1;
    private final Point p2;
    private float weight;
    private float distance;

    public final Point getP1() {
        return this.p1;
    }

    public final Point getP2() {
        return this.p2;
    }

    public final float getWeight() {
        return this.weight;
    }

    public final void setWeight(float weight) {
        this.weight = weight;
    }

    public final float getDistance() {
        return this.distance;
    }

    public PointMatch(Point p1, Point p2, float weight) {
        this.p1 = p1;
        this.p2 = p2;
        this.weight = weight;
        this.distance = Point.distance(p1, p2);
    }

    public PointMatch(Point p1, Point p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.weight = 1.0f;
        this.distance = Point.distance(p1, p2);
    }

    public final void apply(Model model) {
        this.p1.apply(model);
        this.distance = Point.distance(this.p1, this.p2);
    }

    public static final ArrayList<PointMatch> flip(Collection<PointMatch> matches) {
        ArrayList<PointMatch> list = new ArrayList<PointMatch>();
        for (PointMatch match : matches) {
            list.add(new PointMatch(match.p2, match.p1, match.weight));
        }
        return list;
    }
}

