/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.visualattention;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashSet;

public class StentifordModel {
    private int neighbourhoodSize = 3;
    private int maxChecks = 100;
    private int maxDist = 40;
    private HashSet<Integer> randomNeighbourhood = new HashSet(this.neighbourhoodSize);
    static int radius = 2;
    static int[][] possibleNeighbours;
    private int[][] attentionModel;

    public StentifordModel(int neighbourhoodSize, int maxChecks, int maxDist) {
        this.neighbourhoodSize = neighbourhoodSize;
        this.maxChecks = maxChecks;
        this.maxDist = maxDist;
    }

    public StentifordModel() {
    }

    public void extract(BufferedImage img) {
        int[][] nx = new int[this.neighbourhoodSize][3];
        int[][] ny = new int[this.neighbourhoodSize][3];
        boolean match = true;
        this.attentionModel = new int[img.getWidth()][img.getHeight()];
        for (int i = 0; i < this.attentionModel.length; ++i) {
            for (int j = 0; j < this.attentionModel[i].length; ++j) {
                this.attentionModel[i][j] = 0;
            }
        }
        WritableRaster raster = img.getRaster();
        for (int x = radius; x < raster.getWidth() - radius; ++x) {
            for (int y = radius; y < raster.getHeight() - radius; ++y) {
                this.createRandomNeighbourhood();
                this.getNeighbourhood(x, y, nx, raster);
                for (int checks = 0; checks < this.maxChecks; ++checks) {
                    this.getNeighbourhood((int)(Math.random() * (double)(img.getWidth() - 2 * radius) + (double)radius), (int)(Math.random() * (double)(img.getHeight() - 2 * radius) + (double)radius), ny, raster);
                    match = true;
                    for (int i = 0; i < nx.length; ++i) {
                        if (this.getDistance(nx[i], ny[i]) <= this.maxDist) continue;
                        match = false;
                        break;
                    }
                    if (match) continue;
                    int[] nArray = this.attentionModel[x];
                    int n = y;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        System.out.println("");
    }

    private int getDistance(int[] p1, int[] p2) {
        int sum = 0;
        for (int i = 0; i < p1.length; ++i) {
            sum += Math.abs(p1[i] - p2[i]);
        }
        return sum;
    }

    private void getNeighbourhood(int x, int y, int[][] values, WritableRaster raster) {
        int k = 0;
        for (int n : this.randomNeighbourhood) {
            raster.getPixel(x + possibleNeighbours[n][0], y + possibleNeighbours[n][1], values[k]);
            StentifordModel.rgb2hsv(values[k][0], values[k][1], values[k][2], values[k]);
            ++k;
        }
    }

    private void createRandomNeighbourhood() {
        this.randomNeighbourhood.clear();
        while (this.randomNeighbourhood.size() < this.neighbourhoodSize) {
            int n = (int)(Math.random() * (double)possibleNeighbours.length);
            if (n == possibleNeighbours.length) {
                --n;
            }
            this.randomNeighbourhood.add(n);
        }
    }

    public int[][] getAttentionModel() {
        return this.attentionModel;
    }

    public BufferedImage getAttentionVisualization() {
        BufferedImage result = new BufferedImage(this.attentionModel.length, this.attentionModel[0].length, 1);
        int[] pixel = new int[3];
        for (int i = 0; i < this.attentionModel.length; ++i) {
            for (int j = 0; j < this.attentionModel[i].length; ++j) {
                pixel[0] = (int)((float)this.attentionModel[i][j] / (float)this.maxChecks * 255.0f);
                pixel[1] = (int)((float)this.attentionModel[i][j] / (float)this.maxChecks * 255.0f);
                pixel[2] = (int)((float)this.attentionModel[i][j] / (float)this.maxChecks * 255.0f);
                result.getRaster().setPixel(i, j, pixel);
            }
        }
        return result;
    }

    public static void rgb2hsv(int r, int g, int b, int[] hsv) {
        int min = Math.min(r, g);
        min = Math.min(min, b);
        int max = Math.max(r, g);
        max = Math.max(max, b);
        int delMax = max - min;
        float H = 0.0f;
        float S = 0.0f;
        float V = (float)max / 255.0f;
        if (delMax == 0) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = (float)delMax / 255.0f;
            if (r == max) {
                H = g >= b ? ((float)g / 255.0f - (float)b / 255.0f) / (float)delMax / 255.0f * 60.0f : ((float)g / 255.0f - (float)b / 255.0f) / (float)delMax / 255.0f * 60.0f + 360.0f;
            } else if (g == max) {
                H = (2.0f + ((float)b / 255.0f - (float)r / 255.0f) / (float)delMax / 255.0f) * 60.0f;
            } else if (b == max) {
                H = (4.0f + ((float)r / 255.0f - (float)g / 255.0f) / (float)delMax / 255.0f) * 60.0f;
            }
        }
        hsv[0] = (int)H;
        hsv[1] = (int)(S * 100.0f);
        hsv[2] = (int)(V * 100.0f);
    }

    static {
        int side = 2 * radius + 1;
        possibleNeighbours = new int[side * side - 1][2];
        int count = 0;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                if (j == 0 && i == 0) continue;
                StentifordModel.possibleNeighbours[count][0] = i;
                StentifordModel.possibleNeighbours[count][1] = j;
                ++count;
            }
        }
    }
}

