/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import net.semanticmetadata.lire.AbstractImageSearcher;
import net.semanticmetadata.lire.ImageDuplicates;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.GenericDocumentBuilder;
import net.semanticmetadata.lire.impl.SimpleImageSearchHits;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.indexing.hashing.BitSampling;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.DefaultSimilarity;

public class BitSamplingImageSearcher
extends AbstractImageSearcher {
    private int maxResultsHashBased = 1000;
    private int maximumHits = 100;
    private String featureFieldName = null;
    private LireFeature feature = null;
    private String hashesFieldName = null;
    private boolean partialHashes = false;

    public BitSamplingImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, LireFeature feature) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        try {
            BitSampling.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public BitSamplingImageSearcher(int maximumHits, LireFeature feature) {
        this.maximumHits = maximumHits;
        this.featureFieldName = GenericDocumentBuilder.fieldForClass.get(feature.getClass());
        this.hashesFieldName = this.featureFieldName + "_hash";
        this.feature = feature;
        try {
            BitSampling.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public BitSamplingImageSearcher(int maximumHits, LireFeature feature, boolean useFastSearch) {
        this.maximumHits = maximumHits;
        this.featureFieldName = GenericDocumentBuilder.fieldForClass.get(feature.getClass());
        this.hashesFieldName = this.featureFieldName + "_hash";
        this.feature = feature;
        this.partialHashes = useFastSearch;
        try {
            BitSampling.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public BitSamplingImageSearcher(int maximumHits, LireFeature feature, int numHashedResults) {
        this.maximumHits = maximumHits;
        this.featureFieldName = GenericDocumentBuilder.fieldForClass.get(feature.getClass());
        this.hashesFieldName = this.featureFieldName + "_hash";
        this.feature = feature;
        this.maxResultsHashBased = numHashedResults;
        try {
            BitSampling.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public BitSamplingImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, LireFeature feature, int numHashedResults) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        this.maxResultsHashBased = numHashedResults;
        try {
            BitSampling.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public BitSamplingImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, LireFeature feature, InputStream hashes) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        try {
            BitSampling.readHashFunctions(hashes);
            hashes.close();
        }
        catch (IOException e) {
            System.err.println("Error reading has functions from given input stream.");
            e.printStackTrace();
        }
    }

    public BitSamplingImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, LireFeature feature, InputStream hashes, int numHashedResults) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        this.maxResultsHashBased = numHashedResults;
        try {
            BitSampling.readHashFunctions(hashes);
            hashes.close();
        }
        catch (IOException e) {
            System.err.println("Error reading has functions from given input stream.");
            e.printStackTrace();
        }
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        try {
            LireFeature queryFeature = (LireFeature)this.feature.getClass().newInstance();
            queryFeature.extract(image);
            int[] ints = BitSampling.generateHashes(queryFeature.getDoubleHistogram());
            String[] hashes = new String[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                hashes[i] = Integer.toString(ints[i]);
            }
            return this.search(hashes, queryFeature, reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        try {
            LireFeature queryFeature = (LireFeature)this.feature.getClass().newInstance();
            queryFeature.setByteArrayRepresentation(doc.getBinaryValue((String)this.featureFieldName).bytes, doc.getBinaryValue((String)this.featureFieldName).offset, doc.getBinaryValue((String)this.featureFieldName).length);
            return this.search(doc.getValues(this.hashesFieldName)[0].split(" "), queryFeature, reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageSearchHits search(String[] hashes, LireFeature queryFeature, IndexReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher(reader);
        BooleanQuery query = new BooleanQuery();
        for (int i = 0; i < hashes.length; ++i) {
            if (this.partialHashes) {
                if (!(Math.random() < 0.5)) continue;
                query.add(new BooleanClause((Query)new TermQuery(new Term(this.hashesFieldName, hashes[i] + "")), BooleanClause.Occur.SHOULD));
                continue;
            }
            query.add(new BooleanClause((Query)new TermQuery(new Term(this.hashesFieldName, hashes[i] + "")), BooleanClause.Occur.SHOULD));
        }
        TopDocs docs = searcher.search((Query)query, this.maxResultsHashBased);
        TreeSet<SimpleResult> resultScoreDocs = new TreeSet<SimpleResult>();
        float maxDistance = -1.0f;
        for (int i = 0; i < docs.scoreDocs.length; ++i) {
            this.feature.setByteArrayRepresentation(reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).bytes, reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).offset, reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).length);
            float tmpScore = queryFeature.getDistance(this.feature);
            assert (tmpScore >= 0.0f);
            if (resultScoreDocs.size() < this.maximumHits) {
                resultScoreDocs.add(new SimpleResult(tmpScore, reader.document(docs.scoreDocs[i].doc), docs.scoreDocs[i].doc));
                maxDistance = Math.max(maxDistance, tmpScore);
                continue;
            }
            if (!(tmpScore < maxDistance)) continue;
            resultScoreDocs.remove(resultScoreDocs.last());
            resultScoreDocs.add(new SimpleResult(tmpScore, reader.document(docs.scoreDocs[i].doc), docs.scoreDocs[i].doc));
            maxDistance = resultScoreDocs.last().getDistance();
        }
        assert (resultScoreDocs.size() <= this.maximumHits);
        return new SimpleImageSearchHits(resultScoreDocs, maxDistance);
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("not implemented.");
    }

    class BaseSimilarity
    extends DefaultSimilarity {
        BaseSimilarity() {
        }

        public float tf(float freq) {
            return freq;
        }

        public float idf(long docFreq, long numDocs) {
            return 1.0f;
        }

        public float coord(int overlap, int maxOverlap) {
            return 1.0f;
        }

        public float queryNorm(float sumOfSquaredWeights) {
            return 1.0f;
        }

        public float sloppyFreq(int distance) {
            return 1.0f;
        }

        public float lengthNorm(FieldInvertState state) {
            return 1.0f;
        }
    }
}

