/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import net.semanticmetadata.lire.AbstractDocumentBuilder;
import net.semanticmetadata.lire.DocumentBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;

public class ChainedDocumentBuilder
extends AbstractDocumentBuilder {
    private LinkedList<DocumentBuilder> builders = new LinkedList();
    private boolean docsCreated = false;

    public void addBuilder(DocumentBuilder builder) {
        if (this.docsCreated) {
            throw new UnsupportedOperationException("Cannot modify chained builder after documents have been created!");
        }
        this.builders.add(builder);
    }

    @Override
    public Field[] createDescriptorFields(BufferedImage image) {
        this.docsCreated = true;
        LinkedList<Field> resultList = new LinkedList<Field>();
        if (this.builders.size() >= 1) {
            for (DocumentBuilder builder : this.builders) {
                Field[] fields = builder.createDescriptorFields(image);
                for (int i = 0; i < fields.length; ++i) {
                    resultList.add(fields[i]);
                }
            }
        }
        return resultList.toArray(new Field[resultList.size()]);
    }

    @Override
    public Document createDocument(BufferedImage image, String identifier) throws FileNotFoundException {
        this.docsCreated = true;
        Document doc = new Document();
        if (identifier != null) {
            doc.add((IndexableField)new StoredField("descriptorImageIdentifier", identifier));
        }
        if (this.builders.size() >= 1) {
            for (DocumentBuilder builder : this.builders) {
                Field[] fields = builder.createDescriptorFields(image);
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    doc.add((IndexableField)field);
                }
            }
        }
        return doc;
    }
}

