/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;

public class DocumentFactory {
    static Logger logger = Logger.getLogger(DocumentFactory.class.getName());

    public static Document createColorOnlyDocument(Color color) {
        assert (color != null);
        int imgWidth = 64;
        BufferedImage img = new BufferedImage(imgWidth, imgWidth, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, imgWidth, imgWidth);
        ColorLayout scd = new ColorLayout();
        scd.extract(img);
        String sc = scd.getStringRepresentation();
        logger.fine("Extraction from image finished");
        Document doc = new Document();
        if (sc != null) {
            doc.add((IndexableField)new StringField("descriptorColorLayout", sc, Field.Store.YES));
        }
        return doc;
    }
}

