/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.semanticmetadata.lire.AbstractImageSearcher;
import net.semanticmetadata.lire.ImageDuplicates;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.SimpleImageDuplicates;
import net.semanticmetadata.lire.impl.SimpleImageSearchHits;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;

public class GenericImageSearcher
extends AbstractImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    Class<?> descriptorClass;
    String fieldName;
    private int maxHits = 10;
    protected TreeSet<SimpleResult> docs;
    private LireFeature cachedInstance;

    public GenericImageSearcher(int maxHits, Class<?> descriptorClass, String fieldName) {
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
        try {
            this.cachedInstance = (LireFeature)descriptorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        this.logger.finer("Starting extraction.");
        LireFeature lireFeature = null;
        SimpleImageSearchHits searchHits = null;
        try {
            lireFeature = (LireFeature)this.descriptorClass.newInstance();
            BufferedImage bimg = image;
            if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
                bimg = ImageUtils.scaleImage(image, 1024);
            }
            lireFeature.extract(bimg);
            this.logger.fine("Extraction from image finished");
            float maxDistance = this.findSimilar(reader, lireFeature);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    protected float findSimilar(IndexReader reader, LireFeature lireFeature) throws IOException {
        float maxDistance = -1.0f;
        float overallMaxDistance = -1.0f;
        float tmpDistance = 0.0f;
        this.docs.clear();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = reader.numDocs();
        Document d = null;
        for (int i = 0; i < docs; ++i) {
            if (reader.hasDeletions() && !liveDocs.get(i)) continue;
            d = reader.document(i);
            tmpDistance = this.getDistance(d, lireFeature);
            assert (tmpDistance >= 0.0f);
            if (overallMaxDistance < tmpDistance) {
                overallMaxDistance = tmpDistance;
            }
            if (maxDistance < 0.0f) {
                maxDistance = tmpDistance;
            }
            if (this.docs.size() < this.maxHits) {
                this.docs.add(new SimpleResult(tmpDistance, d, i));
                if (!(tmpDistance > maxDistance)) continue;
                maxDistance = tmpDistance;
                continue;
            }
            if (!(tmpDistance < maxDistance)) continue;
            this.docs.remove(this.docs.last());
            this.docs.add(new SimpleResult(tmpDistance, d, i));
            maxDistance = this.docs.last().getDistance();
        }
        return maxDistance;
    }

    protected float getDistance(Document d, LireFeature lireFeature) {
        float distance = 0.0f;
        String[] cls = d.getValues(this.fieldName);
        if (cls != null && cls.length > 0) {
            this.cachedInstance.setStringRepresentation(cls[0]);
            distance = lireFeature.getDistance(this.cachedInstance);
        } else {
            this.logger.warning("No feature stored in this document!");
        }
        return distance;
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        SimpleImageSearchHits searchHits = null;
        try {
            LireFeature lireFeature = (LireFeature)this.descriptorClass.newInstance();
            String[] cls = doc.getValues(this.fieldName);
            if (cls != null && cls.length > 0) {
                lireFeature.setStringRepresentation(cls[0]);
            }
            float maxDistance = this.findSimilar(reader, lireFeature);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        SimpleImageDuplicates simpleImageDuplicates = null;
        try {
            Document doc = reader.document(0);
            LireFeature lireFeature = (LireFeature)this.descriptorClass.newInstance();
            String[] cls = doc.getValues(this.fieldName);
            if (cls != null && cls.length > 0) {
                lireFeature.setStringRepresentation(cls[0]);
            }
            HashMap duplicates = new HashMap();
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
            int docs = reader.numDocs();
            int numDuplicates = 0;
            for (int i = 0; i < docs; ++i) {
                if (reader.hasDeletions() && !liveDocs.get(i)) continue;
                Document d = reader.document(i);
                float distance = this.getDistance(d, lireFeature);
                if (!duplicates.containsKey(Float.valueOf(distance))) {
                    duplicates.put(Float.valueOf(distance), new LinkedList());
                } else {
                    ++numDuplicates;
                }
                ((List)duplicates.get(Float.valueOf(distance))).add(d.getField("descriptorImageIdentifier").stringValue());
            }
            if (numDuplicates == 0) {
                return null;
            }
            LinkedList<List<String>> results = new LinkedList<List<String>>();
            Iterator i$ = duplicates.keySet().iterator();
            while (i$.hasNext()) {
                float f = ((Float)i$.next()).floatValue();
                if (((List)duplicates.get(Float.valueOf(f))).size() <= 1) continue;
                results.add((List<String>)duplicates.get(Float.valueOf(f)));
            }
            simpleImageDuplicates = new SimpleImageDuplicates(results);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return simpleImageDuplicates;
    }

    public String toString() {
        return "GenericSearcher using " + this.descriptorClass.getName();
    }
}

