/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import org.apache.lucene.document.Document;

public class SimpleResult
implements Comparable<SimpleResult> {
    private float distance;
    private Document document;
    private int indexNumber = 0;

    public SimpleResult(float distance, Document document, int indexNumber) {
        this.distance = distance;
        this.document = document;
        this.indexNumber = indexNumber;
    }

    public float getDistance() {
        assert (this.distance >= 0.0f);
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public int getIndexNumber() {
        return this.indexNumber;
    }

    @Override
    public int compareTo(SimpleResult o) {
        int compareValue = (int)Math.signum(this.distance - o.distance);
        if (compareValue == 0 && this.indexNumber != o.indexNumber) {
            return (int)Math.signum(this.indexNumber - o.indexNumber);
        }
        return compareValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleResult)) {
            return false;
        }
        return this.document.equals(((SimpleResult)obj).document) && this.indexNumber == ((SimpleResult)obj).indexNumber;
    }
}

