/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexing.hashing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BitSampling {
    public static double w = 4.0;
    public static int numFunctionBundles = 100;
    private static int bits = 12;
    public static int dimensions = 640;
    public static final String hashFunctionsFileName = "LshBitSampling.obj";
    private static double[][][] hashes = null;
    private static double[] lookUp = new double[32];

    public static void main(String[] args) {
        try {
            BitSampling.generateHashFunctions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateHashFunctions() throws IOException {
        File hashFile = new File(hashFunctionsFileName);
        if (!hashFile.exists()) {
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(hashFile)));
            oos.writeInt(bits);
            oos.writeInt(dimensions);
            oos.writeInt(numFunctionBundles);
            for (int c = 0; c < numFunctionBundles; ++c) {
                for (int i = 0; i < bits; ++i) {
                    for (int j = 0; j < dimensions; ++j) {
                        oos.writeFloat((float)(Math.random() * w - w / 2.0));
                    }
                }
            }
            oos.close();
        } else {
            System.err.println("Hashes could not be written: LshBitSampling.obj already exists");
        }
    }

    public static void generateHashFunctions(String hashFunctionsFileName) throws IOException {
        File hashFile = new File(hashFunctionsFileName);
        if (!hashFile.exists()) {
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(hashFile)));
            oos.writeInt(bits);
            oos.writeInt(dimensions);
            oos.writeInt(numFunctionBundles);
            for (int c = 0; c < numFunctionBundles; ++c) {
                for (int i = 0; i < bits; ++i) {
                    for (int j = 0; j < dimensions; ++j) {
                        oos.writeFloat((float)(Math.random() * w - w / 2.0));
                    }
                }
            }
            oos.close();
        } else {
            System.err.println("Hashes could not be written: " + hashFunctionsFileName + " already exists");
        }
    }

    public static double[][][] readHashFunctions() throws IOException {
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(BitSampling.class.getResourceAsStream(hashFunctionsFileName)));
        int bits = ois.readInt();
        int dimensions = ois.readInt();
        int numFunctionBundles = ois.readInt();
        double[][][] hashFunctions = new double[numFunctionBundles][bits][dimensions];
        for (int i = 0; i < hashFunctions.length; ++i) {
            double[][] functionBundle = hashFunctions[i];
            for (int j = 0; j < functionBundle.length; ++j) {
                double[] bitFunctions = functionBundle[j];
                for (int k = 0; k < bitFunctions.length; ++k) {
                    bitFunctions[k] = ois.readFloat();
                }
            }
        }
        hashes = hashFunctions;
        return hashFunctions;
    }

    public static double[][][] readHashFunctions(InputStream inputStream) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(inputStream));
        int bits = ois.readInt();
        int dimensions = ois.readInt();
        int numFunctionBundles = ois.readInt();
        double[][][] hashFunctions = new double[numFunctionBundles][bits][dimensions];
        for (int i = 0; i < hashFunctions.length; ++i) {
            double[][] functionBundle = hashFunctions[i];
            for (int j = 0; j < functionBundle.length; ++j) {
                double[] bitFunctions = functionBundle[j];
                for (int k = 0; k < bitFunctions.length; ++k) {
                    bitFunctions[k] = ois.readFloat();
                }
            }
        }
        hashes = hashFunctions;
        return hashFunctions;
    }

    public static int[] generateHashes(double[] histogram) {
        int[] hashResults = new int[hashes.length];
        for (int i = 0; i < hashes.length; ++i) {
            double[][] hashBundle = hashes[i];
            for (int j = 0; j < hashBundle.length; ++j) {
                double val = 0.0;
                double[] hashBit = hashBundle[j];
                for (int k = 0; k < histogram.length; ++k) {
                    val += hashBit[k] * histogram[k];
                }
                int n = i;
                hashResults[n] = (int)((double)hashResults[n] + lookUp[j] * (double)(!(val < 0.0) ? 1 : 0));
            }
        }
        return hashResults;
    }

    public static void setW(double w) {
        BitSampling.w = w;
    }

    public static void setNumFunctionBundles(int numFunctionBundles) {
        BitSampling.numFunctionBundles = numFunctionBundles;
    }

    public static int getBits() {
        return bits;
    }

    public static void setBits(int bits) {
        BitSampling.bits = bits;
    }

    public static double getW() {
        return w;
    }

    public static int getNumFunctionBundles() {
        return numFunctionBundles;
    }

    static {
        for (int i = 0; i < lookUp.length; ++i) {
            BitSampling.lookUp[i] = Math.pow(2.0, i);
        }
    }
}

