/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;

public class ImageUtils {
    public static BufferedImage scaleImage(BufferedImage image, int maxSideLength) {
        assert (maxSideLength > 0);
        double originalWidth = image.getWidth();
        double originalHeight = image.getHeight();
        double scaleFactor = 0.0;
        scaleFactor = originalWidth > originalHeight ? (double)maxSideLength / originalWidth : (double)maxSideLength / originalHeight;
        if (scaleFactor < 1.0 && (int)(originalWidth * scaleFactor) > 1 && (int)(originalHeight * scaleFactor) > 1) {
            BufferedImage img = new BufferedImage((int)(originalWidth * scaleFactor), (int)(originalHeight * scaleFactor), 1);
            Graphics g = img.getGraphics();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, 0, 0, img.getWidth(), img.getHeight(), null);
            return img;
        }
        return image;
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height) {
        assert (width > 0 && height > 0);
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics g = img.getGraphics();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, 0, 0, img.getWidth(), img.getHeight(), null);
        return img;
    }

    public static BufferedImage cropImage(BufferedImage image, int fromX, int fromY, int width, int height) {
        assert (width > 0 && height > 0);
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics g = img.getGraphics();
        g.drawImage(image, fromX, fromY, img.getWidth(), img.getHeight(), null);
        return img;
    }

    public static BufferedImage getGrayscaleImage(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        result.getGraphics().drawImage(image, 0, 0, null);
        return result;
    }

    public static void invertImage(BufferedImage image) {
        WritableRaster inRaster = image.getRaster();
        int[] p = new int[3];
        float v = 0.0f;
        for (int x = 0; x < inRaster.getWidth(); ++x) {
            for (int y = 0; y < inRaster.getHeight(); ++y) {
                inRaster.getPixel(x, y, p);
                p[0] = 255 - p[0];
                inRaster.setPixel(x, y, p);
            }
        }
    }

    public static BufferedImage createWorkingCopy(BufferedImage bimg) {
        BufferedImage image;
        if (bimg.getType() == 1) {
            image = bimg;
        } else {
            image = new BufferedImage(bimg.getWidth(), bimg.getHeight(), 1);
            Graphics2D g2d = image.createGraphics();
            g2d.drawImage(bimg, null, 0, 0);
        }
        return image;
    }

    public static BufferedImage trimWhiteSpace(BufferedImage img) {
        int i;
        WritableRaster raster = ImageUtils.getGrayscaleImage(img).getRaster();
        int[] pixels = new int[Math.max(raster.getWidth(), raster.getHeight())];
        int thresholdWhite = 253;
        int trimTop = 0;
        int trimBottom = 0;
        int trimLeft = 0;
        int trimRight = 0;
        boolean white = true;
        while (white) {
            raster.getPixels(0, trimTop, raster.getWidth(), 1, pixels);
            for (i = 0; i < raster.getWidth(); ++i) {
                if (pixels[i] >= thresholdWhite) continue;
                white = false;
            }
            if (!white || ++trimTop <= raster.getHeight() - 10) continue;
            return img;
        }
        white = true;
        while (white) {
            raster.getPixels(0, raster.getHeight() - 1 - trimBottom, raster.getWidth(), 1, pixels);
            for (i = 0; i < raster.getWidth(); ++i) {
                if (pixels[i] >= thresholdWhite) continue;
                white = false;
            }
            if (!white) continue;
            ++trimBottom;
        }
        white = true;
        while (white) {
            raster.getPixels(trimLeft, 0, 1, raster.getHeight(), pixels);
            for (i = 0; i < raster.getHeight(); ++i) {
                if (pixels[i] >= thresholdWhite) continue;
                white = false;
            }
            if (!white) continue;
            ++trimLeft;
        }
        white = true;
        while (white) {
            raster.getPixels(raster.getWidth() - 1 - trimRight, 0, 1, raster.getHeight(), pixels);
            for (i = 0; i < raster.getHeight(); ++i) {
                if (pixels[i] >= thresholdWhite) continue;
                white = false;
            }
            if (!white) continue;
            ++trimRight;
        }
        BufferedImage result = new BufferedImage(raster.getWidth() - (trimLeft + trimRight), raster.getHeight() - (trimTop + trimBottom), 1);
        result.getGraphics().drawImage(img, 0, 0, result.getWidth(), result.getHeight(), trimLeft, trimTop, img.getWidth() - trimRight, img.getHeight() - trimBottom, null);
        return result;
    }

    public static float[] makeGaussianKernel(int radius, float sigma) {
        float[] kernel = new float[radius * radius];
        float sum = 0.0f;
        for (int y = 0; y < radius; ++y) {
            for (int x = 0; x < radius; ++x) {
                int off = y * radius + x;
                int xx = x - radius / 2;
                int yy = y - radius / 2;
                kernel[off] = (float)Math.pow(Math.E, (float)(-(xx * xx + yy * yy)) / (2.0f * (sigma * sigma)));
                sum += kernel[off];
            }
        }
        int i = 0;
        while (i < kernel.length) {
            int n = i++;
            kernel[n] = kernel[n] / sum;
        }
        return kernel;
    }

    public static BufferedImage differenceOfGaussians(BufferedImage image) {
        BufferedImage img1 = ImageUtils.getGrayscaleImage(image);
        BufferedImage img2 = ImageUtils.getGrayscaleImage(image);
        ConvolveOp gaussian1 = new ConvolveOp(new Kernel(5, 5, ImageUtils.makeGaussianKernel(5, 1.0f)));
        ConvolveOp gaussian2 = new ConvolveOp(new Kernel(5, 5, ImageUtils.makeGaussianKernel(5, 2.0f)));
        img1 = gaussian1.filter(img1, null);
        img2 = gaussian2.filter(img2, null);
        WritableRaster r1 = img1.getRaster();
        WritableRaster r2 = img2.getRaster();
        int[] tmp1 = new int[3];
        int[] tmp2 = new int[3];
        for (int x = 0; x < img1.getWidth(); ++x) {
            for (int y = 0; y < img1.getHeight(); ++y) {
                r1.getPixel(x, y, tmp1);
                r2.getPixel(x, y, tmp2);
                tmp1[0] = Math.abs(tmp1[0] - tmp2[0]);
                if (tmp1[0] > 5) {
                    tmp1[0] = 255;
                }
                r1.setPixel(x, y, tmp1);
            }
        }
        return img1;
    }

    public static BufferedImage thresholdImage(BufferedImage image, int threshold) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        result.getGraphics().drawImage(image, 0, 0, null);
        WritableRaster raster = result.getRaster();
        int[] pixels = new int[image.getWidth()];
        for (int y = 0; y < image.getHeight(); ++y) {
            raster.getPixels(0, y, image.getWidth(), 1, pixels);
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = pixels[i] < threshold ? 0 : 255;
            }
            raster.setPixels(0, y, image.getWidth(), 1, pixels);
        }
        return result;
    }

    public static BufferedImage get8BitRGBImage(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 5 || bufferedImage.getSampleModel().getSampleSize(0) != 8) {
            BufferedImage img = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            img.getGraphics().drawImage(bufferedImage, 0, 0, null);
            bufferedImage = img;
        }
        return bufferedImage;
    }
}

