/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils;

public class MetricsUtils {
    public static double distL1(int[] h1, int[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)Math.abs(h1[i] - h2[i]);
        }
        return sum / (double)h1.length;
    }

    public static double distL1(double[] h1, double[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += Math.abs(h1[i] - h2[i]);
        }
        return sum / (double)h1.length;
    }

    public static double distL2(int[] h1, int[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)((h1[i] - h2[i]) * (h1[i] - h2[i]));
        }
        return Math.sqrt(sum);
    }

    public static double distL2(double[] h1, double[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] - h2[i]) * (h1[i] - h2[i]);
        }
        return Math.sqrt(sum);
    }

    public static float distL2(float[] h1, float[] h2) {
        float sum = 0.0f;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] - h2[i]) * (h1[i] - h2[i]);
        }
        return (float)Math.sqrt(sum);
    }

    public static double jsd(int[] h1, int[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] > 0 ? (double)h1[i] * Math.log(2.0 * (double)h1[i] / (double)(h1[i] + h2[i])) : 0.0) + (h2[i] > 0 ? (double)h2[i] * Math.log(2.0 * (double)h2[i] / (double)(h1[i] + h2[i])) : 0.0);
        }
        return sum;
    }

    public static double jsd(byte[] h1, byte[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] > 0 ? (double)h1[i] * Math.log(2.0 * (double)h1[i] / (double)(h1[i] + h2[i])) : 0.0) + (h2[i] > 0 ? (double)h2[i] * Math.log(2.0 * (double)h2[i] / (double)(h1[i] + h2[i])) : 0.0);
        }
        return sum;
    }

    public static float jsd(float[] h1, float[] h2) {
        float sum = 0.0f;
        for (int i = 0; i < h1.length; ++i) {
            sum = (float)((double)sum + ((h1[i] > 0.0f ? (double)(h1[i] / 2.0f) * Math.log(2.0f * h1[i] / (h1[i] + h2[i])) : 0.0) + (h2[i] > 0.0f ? (double)(h2[i] / 2.0f) * Math.log(2.0f * h2[i] / (h1[i] + h2[i])) : 0.0)));
        }
        return sum;
    }

    public static float jsd(double[] h1, double[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] > 0.0 ? h1[i] / 2.0 * Math.log(2.0 * h1[i] / (h1[i] + h2[i])) : 0.0) + (h2[i] > 0.0 ? h2[i] / 2.0 * Math.log(2.0 * h2[i] / (h1[i] + h2[i])) : 0.0);
        }
        return (float)sum;
    }

    public static double tanimoto(int[] h1, int[] h2) {
        int i;
        double result = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmpCnt1 = 0.0;
        double tmpCnt2 = 0.0;
        double tmpCnt3 = 0.0;
        for (i = 0; i < h1.length; ++i) {
            tmp1 += (double)h1[i];
            tmp2 += (double)h2[i];
        }
        if (tmp1 == 0.0 && tmp2 == 0.0) {
            return 0.0;
        }
        if (tmp1 == 0.0 || tmp2 == 0.0) {
            return 100.0;
        }
        if (tmp1 > 0.0 && tmp2 > 0.0) {
            for (i = 0; i < h1.length; ++i) {
                tmpCnt1 += (double)h1[i] / tmp1 * ((double)h2[i] / tmp2);
                tmpCnt2 += (double)h2[i] / tmp2 * ((double)h2[i] / tmp2);
                tmpCnt3 += (double)h1[i] / tmp1 * ((double)h1[i] / tmp1);
            }
            result = 100.0 - 100.0 * (tmpCnt1 / (tmpCnt2 + tmpCnt3 - tmpCnt1));
        }
        return result;
    }

    public static double tanimoto(float[] h1, float[] h2) {
        int i;
        double result = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmpCnt1 = 0.0;
        double tmpCnt2 = 0.0;
        double tmpCnt3 = 0.0;
        for (i = 0; i < h1.length; ++i) {
            tmp1 += (double)h1[i];
            tmp2 += (double)h2[i];
        }
        if (tmp1 == 0.0 && tmp2 == 0.0) {
            return 0.0;
        }
        if (tmp1 == 0.0 || tmp2 == 0.0) {
            return 100.0;
        }
        if (tmp1 > 0.0 && tmp2 > 0.0) {
            for (i = 0; i < h1.length; ++i) {
                tmpCnt1 += (double)h1[i] / tmp1 * ((double)h2[i] / tmp2);
                tmpCnt2 += (double)h2[i] / tmp2 * ((double)h2[i] / tmp2);
                tmpCnt3 += (double)h1[i] / tmp1 * ((double)h1[i] / tmp1);
            }
            result = 100.0 - 100.0 * (tmpCnt1 / (tmpCnt2 + tmpCnt3 - tmpCnt1));
        }
        return result;
    }

    public static double tanimoto(double[] h1, double[] h2) {
        int i;
        double result = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmpCnt1 = 0.0;
        double tmpCnt2 = 0.0;
        double tmpCnt3 = 0.0;
        for (i = 0; i < h1.length; ++i) {
            tmp1 += h1[i];
            tmp2 += h2[i];
        }
        if (tmp1 == 0.0 && tmp2 == 0.0) {
            return 0.0;
        }
        if (tmp1 == 0.0 || tmp2 == 0.0) {
            return 100.0;
        }
        if (tmp1 > 0.0 && tmp2 > 0.0) {
            for (i = 0; i < h1.length; ++i) {
                tmpCnt1 += h1[i] / tmp1 * (h2[i] / tmp2);
                tmpCnt2 += h2[i] / tmp2 * (h2[i] / tmp2);
                tmpCnt3 += h1[i] / tmp1 * (h1[i] / tmp1);
            }
            result = 100.0 - 100.0 * (tmpCnt1 / (tmpCnt2 + tmpCnt3 - tmpCnt1));
        }
        return result;
    }

    public static double cosineCoefficient(double[] hist1, double[] hist2) {
        double distance = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        for (int i = 0; i < hist1.length; ++i) {
            distance += hist1[i] * hist2[i];
            tmp1 += hist1[i] * hist1[i];
            tmp2 += hist2[i] * hist2[i];
        }
        if (tmp1 * tmp2 > 0.0) {
            return distance / (Math.sqrt(tmp1) * Math.sqrt(tmp2));
        }
        return 0.0;
    }

    public static float distL1(float[] h1, float[] h2) {
        float sum = 0.0f;
        for (int i = 0; i < h1.length; ++i) {
            sum += Math.abs(h1[i] - h2[i]);
        }
        return sum;
    }

    public static double distL1(byte[] h1, byte[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)Math.abs(h1[i] - h2[i]);
        }
        return sum;
    }
}

