/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils.cv;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.filters.FastBilateralFilter;
import net.semanticmetadata.lire.imageanalysis.filters.IndexedIntArray;
import net.semanticmetadata.lire.utils.FileUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.cv.KMeans;

public class PixelClustering {
    private static int numberOfColors = 32;

    public static BufferedImage clusterPixels(BufferedImage img) {
        double[] tmpPixel;
        BufferedImage b = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        b.getGraphics().drawImage(img, 0, 0, null);
        IndexedIntArray src = new IndexedIntArray(new int[img.getWidth() * img.getHeight()], 0);
        IndexedIntArray dst = new IndexedIntArray(new int[img.getWidth() * img.getHeight()], 0);
        b.getRaster().getDataElements(0, 0, img.getWidth(), img.getHeight(), src.array);
        FastBilateralFilter fbf = new FastBilateralFilter(img.getWidth(), img.getHeight(), img.getWidth(), 90.0f, 0.3f);
        fbf.apply(src, dst);
        b.getRaster().setDataElements(0, 0, img.getWidth(), img.getHeight(), dst.array);
        img.getGraphics().drawImage(b, 0, 0, null);
        WritableRaster r = img.getRaster();
        ArrayList<double[]> pixels = new ArrayList<double[]>(r.getHeight() * r.getWidth());
        for (int x = 0; x < r.getWidth(); ++x) {
            for (int y = 0; y < r.getHeight(); ++y) {
                tmpPixel = new double[3];
                r.getPixel(x, y, tmpPixel);
                assert (tmpPixel[0] < 256.0);
                assert (tmpPixel[1] < 256.0);
                assert (tmpPixel[2] < 256.0);
                pixels.add(tmpPixel);
            }
        }
        KMeans km = new KMeans(pixels, numberOfColors);
        for (int i = 0; i < 15; ++i) {
            km.step();
        }
        List<double[]> means = km.getMeans();
        tmpPixel = new double[3];
        for (int x = 0; x < r.getWidth(); ++x) {
            for (int y = 0; y < r.getHeight(); ++y) {
                r.getPixel(x, y, tmpPixel);
                int num = -1;
                int count = 0;
                double distance = -1.0;
                double tmpDistance = -1.0;
                for (double[] next : means) {
                    distance = MetricsUtils.distL2(next, tmpPixel);
                    if (num < 0 || distance < tmpDistance) {
                        num = count;
                        tmpDistance = distance;
                    }
                    ++count;
                }
                tmpPixel[0] = Math.floor(means.get(num)[0]);
                tmpPixel[1] = Math.floor(means.get(num)[1]);
                tmpPixel[2] = Math.floor(means.get(num)[2]);
                r.setPixel(x, y, tmpPixel);
            }
        }
        return img;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<File> files = FileUtils.getAllImageFiles(new File("D:\\Temp\\tmp"), false);
        int count = 10;
        for (File next : files) {
            BufferedImage img = ImageIO.read(next);
            BufferedImage toWrite = new BufferedImage(img.getWidth() * 2, img.getHeight(), 1);
            toWrite.getGraphics().drawImage(img, 0, 0, null);
            BufferedImage bufferedImage = PixelClustering.clusterPixels(img);
            toWrite.getGraphics().drawImage(bufferedImage, img.getWidth(), 0, null);
            ImageIO.write((RenderedImage)toWrite, "png", new File("out_test_" + count + ".png"));
            ++count;
        }
    }
}

