/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ZstdOutputStream
extends FilterOutputStream {
    private long stream;
    private long srcPos = 0L;
    private long dstPos = 0L;
    private byte[] dst = null;
    private boolean isClosed = false;
    private static final int dstSize;
    private boolean closeFrameOnFlush;
    private boolean useChecksum;
    private boolean frameClosed = true;
    private int level;

    private static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int initCStream(long var1, int var3, int var4);

    private native int compressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native int flushStream(long var1, byte[] var3, int var4);

    private native int endStream(long var1, byte[] var3, int var4);

    public ZstdOutputStream(OutputStream outputStream, int n, boolean bl, boolean bl2) throws IOException {
        super(outputStream);
        this.closeFrameOnFlush = bl;
        this.level = n;
        this.useChecksum = bl2;
        this.stream = ZstdOutputStream.createCStream();
        this.dst = new byte[dstSize];
    }

    public ZstdOutputStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        this(outputStream, n, bl, false);
    }

    public ZstdOutputStream(OutputStream outputStream, int n) throws IOException {
        this(outputStream, n, false);
    }

    public ZstdOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 3, false);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.frameClosed) {
            n3 = this.initCStream(this.stream, this.level, this.useChecksum ? 1 : 0);
            if (Zstd.isError(n3)) {
                throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(n3));
            }
            this.frameClosed = false;
        }
        n3 = n + n2;
        this.srcPos = n;
        while (this.srcPos < (long)n3) {
            int n4 = this.compressStream(this.stream, this.dst, dstSize, byArray, n3);
            if (Zstd.isError(n4)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(n4));
            }
            if (this.dstPos <= 0L) continue;
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.frameClosed) {
            if (this.closeFrameOnFlush) {
                int n = this.endStream(this.stream, this.dst, dstSize);
                if (Zstd.isError(n)) {
                    throw new IOException("Compression error: " + Zstd.getErrorName(n));
                }
                this.frameClosed = true;
            } else {
                int n = this.flushStream(this.stream, this.dst, dstSize);
                if (Zstd.isError(n)) {
                    throw new IOException("Compression error: " + Zstd.getErrorName(n));
                }
            }
            this.out.write(this.dst, 0, (int)this.dstPos);
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (!this.frameClosed) {
            int n = this.endStream(this.stream, this.dst, dstSize);
            if (Zstd.isError(n)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(n));
            }
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
        ZstdOutputStream.freeCStream(this.stream);
        this.out.close();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
        dstSize = (int)ZstdOutputStream.recommendedCOutSize();
    }
}

