/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.CNTK;

import com.microsoft.CNTK.CNTKLib;
import com.microsoft.CNTK.CNTKLibJNI;
import com.microsoft.CNTK.DeviceDescriptorVector;
import com.microsoft.CNTK.DeviceKind;
import java.util.ArrayList;
import java.util.List;

public class DeviceDescriptor {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DeviceDescriptor(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DeviceDescriptor deviceDescriptor) {
        return deviceDescriptor == null ? 0L : deviceDescriptor.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CNTKLibJNI.delete_DeviceDescriptor(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public List<DeviceDescriptor> getAllDevices() {
        DeviceDescriptorVector deviceDescriptorVector = DeviceDescriptor._AllDevices();
        ArrayList<DeviceDescriptor> arrayList = new ArrayList<DeviceDescriptor>((int)deviceDescriptorVector.size());
        int n = 0;
        while ((long)n < deviceDescriptorVector.size()) {
            arrayList.add(deviceDescriptorVector.get(n));
            ++n;
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        DeviceDescriptor deviceDescriptor = (DeviceDescriptor)object;
        if (deviceDescriptor == null) {
            return false;
        }
        return CNTKLib.AreEqual(this, deviceDescriptor);
    }

    public boolean equals(DeviceDescriptor deviceDescriptor) {
        if (deviceDescriptor == null) {
            return false;
        }
        return CNTKLib.AreEqual(this, deviceDescriptor);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public long getId() {
        return CNTKLibJNI.DeviceDescriptor_getId(this.swigCPtr, this);
    }

    public DeviceKind getType() {
        return DeviceKind.swigToEnum(CNTKLibJNI.DeviceDescriptor_getType(this.swigCPtr, this));
    }

    public boolean isLocked() {
        return CNTKLibJNI.DeviceDescriptor_isLocked(this.swigCPtr, this);
    }

    public static DeviceDescriptor getCPUDevice() {
        return new DeviceDescriptor(CNTKLibJNI.DeviceDescriptor_getCPUDevice(), true);
    }

    public static DeviceDescriptor getGPUDevice(long l) {
        return new DeviceDescriptor(CNTKLibJNI.DeviceDescriptor_getGPUDevice(l), true);
    }

    public static DeviceDescriptor useDefaultDevice() {
        return new DeviceDescriptor(CNTKLibJNI.DeviceDescriptor_useDefaultDevice(), true);
    }

    public static boolean trySetDefaultDevice(DeviceDescriptor deviceDescriptor, boolean bl) {
        return CNTKLibJNI.DeviceDescriptor_trySetDefaultDevice__SWIG_0(DeviceDescriptor.getCPtr(deviceDescriptor), deviceDescriptor, bl);
    }

    public static boolean trySetDefaultDevice(DeviceDescriptor deviceDescriptor) {
        return CNTKLibJNI.DeviceDescriptor_trySetDefaultDevice__SWIG_1(DeviceDescriptor.getCPtr(deviceDescriptor), deviceDescriptor);
    }

    public static void setExcludedDevices(DeviceDescriptorVector deviceDescriptorVector) {
        CNTKLibJNI.DeviceDescriptor_setExcludedDevices(DeviceDescriptorVector.getCPtr(deviceDescriptorVector), deviceDescriptorVector);
    }

    private static DeviceDescriptorVector _AllDevices() {
        return new DeviceDescriptorVector(CNTKLibJNI.DeviceDescriptor__AllDevices(), false);
    }

    public String toString() {
        return CNTKLibJNI.DeviceDescriptor_toString(this.swigCPtr, this);
    }
}

