/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.CNTK;

import com.microsoft.CNTK.CNTKLib;
import com.microsoft.CNTK.CNTKLibJNI;
import com.microsoft.CNTK.DeviceDescriptor;
import com.microsoft.CNTK.FunctionPtrVector;
import com.microsoft.CNTK.ParameterCloningMethod;
import com.microsoft.CNTK.UnorderedMapVariableValuePtr;
import com.microsoft.CNTK.UnorderedMapVariableVariable;
import com.microsoft.CNTK.Variable;
import com.microsoft.CNTK.VariableVector;
import java.util.ArrayList;
import java.util.List;

public class Function {
    private transient long swigCPtr;
    private transient boolean swigCMemOwn;
    private FunctionPtrVector ref;
    public static final int MaxNumOutputs = CNTKLibJNI.Function_MaxNumOutputs_get();

    protected Function(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Function function) {
        return function == null ? 0L : function.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CNTKLibJNI.delete_Function(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void addReference(FunctionPtrVector functionPtrVector) {
        this.ref = functionPtrVector;
    }

    public static Function load(byte[] byArray, DeviceDescriptor deviceDescriptor) {
        return Function.load(byArray, byArray.length, deviceDescriptor);
    }

    public List<Variable> getInputs() {
        VariableVector variableVector = this._Inputs();
        ArrayList<Variable> arrayList = new ArrayList<Variable>((int)variableVector.size());
        int n = 0;
        while ((long)n < variableVector.size()) {
            Variable variable = variableVector.get(n);
            variable.addReference(variableVector);
            arrayList.add(variable);
            ++n;
        }
        return arrayList;
    }

    public List<Variable> getOutputs() {
        VariableVector variableVector = this._Outputs();
        ArrayList<Variable> arrayList = new ArrayList<Variable>((int)variableVector.size());
        int n = 0;
        while ((long)n < variableVector.size()) {
            Variable variable = variableVector.get(n);
            variable.addReference(variableVector);
            arrayList.add(variable);
            ++n;
        }
        return arrayList;
    }

    public List<Variable> getArguments() {
        VariableVector variableVector = this._Arguments();
        ArrayList<Variable> arrayList = new ArrayList<Variable>((int)variableVector.size());
        int n = 0;
        while ((long)n < variableVector.size()) {
            Variable variable = variableVector.get(n);
            variable.addReference(variableVector);
            arrayList.add(variable);
            ++n;
        }
        return arrayList;
    }

    public List<Function> findAllWithName(String string) {
        FunctionPtrVector functionPtrVector = this._FindAllWithName(string);
        ArrayList<Function> arrayList = new ArrayList<Function>((int)functionPtrVector.size());
        int n = 0;
        while ((long)n < functionPtrVector.size()) {
            Function function = functionPtrVector.get(n);
            function.addReference(functionPtrVector);
            arrayList.add(function);
            ++n;
        }
        return arrayList;
    }

    public static Function combine(ArrayList<Variable> arrayList) {
        VariableVector variableVector = new VariableVector();
        for (int i = 0; i < arrayList.size(); ++i) {
            variableVector.add(variableVector.get(i));
        }
        return CNTKLib.Combine(variableVector);
    }

    public String getOpName() {
        return CNTKLibJNI.Function_getOpName(this.swigCPtr, this);
    }

    public long getCurrentVersion() {
        return CNTKLibJNI.Function_getCurrentVersion(this.swigCPtr, this);
    }

    public Function clone(VariableVector variableVector) {
        long l = CNTKLibJNI.Function_clone__SWIG_0(this.swigCPtr, this, VariableVector.getCPtr(variableVector), variableVector);
        return l == 0L ? null : new Function(l, true);
    }

    public void evaluate(UnorderedMapVariableValuePtr unorderedMapVariableValuePtr, UnorderedMapVariableValuePtr unorderedMapVariableValuePtr2, DeviceDescriptor deviceDescriptor) {
        CNTKLibJNI.Function_evaluate__SWIG_0(this.swigCPtr, this, UnorderedMapVariableValuePtr.getCPtr(unorderedMapVariableValuePtr), unorderedMapVariableValuePtr, UnorderedMapVariableValuePtr.getCPtr(unorderedMapVariableValuePtr2), unorderedMapVariableValuePtr2, DeviceDescriptor.getCPtr(deviceDescriptor), deviceDescriptor);
    }

    public void evaluate(UnorderedMapVariableValuePtr unorderedMapVariableValuePtr, UnorderedMapVariableValuePtr unorderedMapVariableValuePtr2) {
        CNTKLibJNI.Function_evaluate__SWIG_1(this.swigCPtr, this, UnorderedMapVariableValuePtr.getCPtr(unorderedMapVariableValuePtr), unorderedMapVariableValuePtr, UnorderedMapVariableValuePtr.getCPtr(unorderedMapVariableValuePtr2), unorderedMapVariableValuePtr2);
    }

    public Function clone(ParameterCloningMethod parameterCloningMethod, UnorderedMapVariableVariable unorderedMapVariableVariable) {
        long l = CNTKLibJNI.Function_clone__SWIG_1(this.swigCPtr, this, parameterCloningMethod.swigValue(), UnorderedMapVariableVariable.getCPtr(unorderedMapVariableVariable), unorderedMapVariableVariable);
        return l == 0L ? null : new Function(l, true);
    }

    public Function clone(ParameterCloningMethod parameterCloningMethod) {
        long l = CNTKLibJNI.Function_clone__SWIG_2(this.swigCPtr, this, parameterCloningMethod.swigValue());
        return l == 0L ? null : new Function(l, true);
    }

    public Function clone() {
        long l = CNTKLibJNI.Function_clone__SWIG_3(this.swigCPtr, this);
        return l == 0L ? null : new Function(l, true);
    }

    public String getName() {
        return CNTKLibJNI.Function_getName(this.swigCPtr, this);
    }

    public void setName(String string) {
        CNTKLibJNI.Function_setName(this.swigCPtr, this, string);
    }

    public String getUid() {
        return CNTKLibJNI.Function_getUid(this.swigCPtr, this);
    }

    public Function getRootFunction() {
        long l = CNTKLibJNI.Function_getRootFunction(this.swigCPtr, this);
        return l == 0L ? null : new Function(l, true);
    }

    public boolean isComposite() {
        return CNTKLibJNI.Function_isComposite(this.swigCPtr, this);
    }

    public boolean isPrimitive() {
        return CNTKLibJNI.Function_isPrimitive(this.swigCPtr, this);
    }

    public boolean isBlock() {
        return CNTKLibJNI.Function_isBlock(this.swigCPtr, this);
    }

    public Function blockRoot() {
        long l = CNTKLibJNI.Function_blockRoot(this.swigCPtr, this);
        return l == 0L ? null : new Function(l, true);
    }

    private VariableVector _Inputs(boolean bl) {
        return new VariableVector(CNTKLibJNI.Function__Inputs__SWIG_0(this.swigCPtr, this, bl), true);
    }

    private VariableVector _Inputs() {
        return new VariableVector(CNTKLibJNI.Function__Inputs__SWIG_1(this.swigCPtr, this), true);
    }

    public Variable getOutput() {
        return new Variable(CNTKLibJNI.Function_getOutput(this.swigCPtr, this), true);
    }

    private VariableVector _Outputs() {
        return new VariableVector(CNTKLibJNI.Function__Outputs(this.swigCPtr, this), true);
    }

    private VariableVector _Arguments(boolean bl) {
        return new VariableVector(CNTKLibJNI.Function__Arguments__SWIG_0(this.swigCPtr, this, bl), true);
    }

    private VariableVector _Arguments() {
        return new VariableVector(CNTKLibJNI.Function__Arguments__SWIG_1(this.swigCPtr, this), true);
    }

    public Function findByName(String string, boolean bl) {
        long l = CNTKLibJNI.Function_findByName__SWIG_0(this.swigCPtr, this, string, bl);
        return l == 0L ? null : new Function(l, true);
    }

    public Function findByName(String string) {
        long l = CNTKLibJNI.Function_findByName__SWIG_1(this.swigCPtr, this, string);
        return l == 0L ? null : new Function(l, true);
    }

    private FunctionPtrVector _FindAllWithName(String string, boolean bl) {
        return new FunctionPtrVector(CNTKLibJNI.Function__FindAllWithName__SWIG_0(this.swigCPtr, this, string, bl), true);
    }

    private FunctionPtrVector _FindAllWithName(String string) {
        return new FunctionPtrVector(CNTKLibJNI.Function__FindAllWithName__SWIG_1(this.swigCPtr, this, string), true);
    }

    public void save(String string) {
        CNTKLibJNI.Function_save(this.swigCPtr, this, string);
    }

    public void restore(String string) {
        CNTKLibJNI.Function_restore(this.swigCPtr, this, string);
    }

    public static Function load(String string, DeviceDescriptor deviceDescriptor) {
        long l = CNTKLibJNI.Function_load__SWIG_0(string, DeviceDescriptor.getCPtr(deviceDescriptor), deviceDescriptor);
        return l == 0L ? null : new Function(l, true);
    }

    public static Function load(String string) {
        long l = CNTKLibJNI.Function_load__SWIG_1(string);
        return l == 0L ? null : new Function(l, true);
    }

    public static Function load(byte[] byArray, long l, DeviceDescriptor deviceDescriptor) {
        long l2 = CNTKLibJNI.Function_load__SWIG_2(byArray, l, DeviceDescriptor.getCPtr(deviceDescriptor), deviceDescriptor);
        return l2 == 0L ? null : new Function(l2, true);
    }

    public static Function load(byte[] byArray, long l) {
        long l2 = CNTKLibJNI.Function_load__SWIG_3(byArray, l);
        return l2 == 0L ? null : new Function(l2, true);
    }

    public String toString(boolean bl) {
        return CNTKLibJNI.Function_toString__SWIG_0(this.swigCPtr, this, bl);
    }

    public String toString() {
        return CNTKLibJNI.Function_toString__SWIG_1(this.swigCPtr, this);
    }
}

