// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/protobuf/timestamp.proto

package com.github.os72.protobuf351;

/**
 * <pre>
 * A Timestamp represents a point in time independent of any time zone
 * or calendar, represented as seconds and fractions of seconds at
 * nanosecond resolution in UTC Epoch time. It is encoded using the
 * Proleptic Gregorian Calendar which extends the Gregorian calendar
 * backwards to year one. It is encoded assuming all minutes are 60
 * seconds long, i.e. leap seconds are "smeared" so that no leap second
 * table is needed for interpretation. Range is from
 * 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z.
 * By restricting to that range, we ensure that we can convert to
 * and from  RFC 3339 date strings.
 * See [https://www.ietf.org/rfc/rfc3339.txt](https://www.ietf.org/rfc/rfc3339.txt).
 * # Examples
 * Example 1: Compute Timestamp from POSIX `time()`.
 *     Timestamp timestamp;
 *     timestamp.set_seconds(time(NULL));
 *     timestamp.set_nanos(0);
 * Example 2: Compute Timestamp from POSIX `gettimeofday()`.
 *     struct timeval tv;
 *     gettimeofday(&amp;tv, NULL);
 *     Timestamp timestamp;
 *     timestamp.set_seconds(tv.tv_sec);
 *     timestamp.set_nanos(tv.tv_usec * 1000);
 * Example 3: Compute Timestamp from Win32 `GetSystemTimeAsFileTime()`.
 *     FILETIME ft;
 *     GetSystemTimeAsFileTime(&amp;ft);
 *     UINT64 ticks = (((UINT64)ft.dwHighDateTime) &lt;&lt; 32) | ft.dwLowDateTime;
 *     // A Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z
 *     // is 11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z.
 *     Timestamp timestamp;
 *     timestamp.set_seconds((INT64) ((ticks / 10000000) - 11644473600LL));
 *     timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));
 * Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.
 *     long millis = System.currentTimeMillis();
 *     Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000)
 *         .setNanos((int) ((millis % 1000) * 1000000)).build();
 * Example 5: Compute Timestamp from current time in Python.
 *     timestamp = Timestamp()
 *     timestamp.GetCurrentTime()
 * # JSON Mapping
 * In JSON format, the Timestamp type is encoded as a string in the
 * [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the
 * format is "{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z"
 * where {year} is always expressed using four digits while {month}, {day},
 * {hour}, {min}, and {sec} are zero-padded to two digits each. The fractional
 * seconds, which can go up to 9 digits (i.e. up to 1 nanosecond resolution),
 * are optional. The "Z" suffix indicates the timezone ("UTC"); the timezone
 * is required, though only UTC (as indicated by "Z") is presently supported.
 * For example, "2017-01-15T01:30:15.01Z" encodes 15.01 seconds past
 * 01:30 UTC on January 15, 2017.
 * In JavaScript, one can convert a Date object to this format using the
 * standard [toISOString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString]
 * method. In Python, a standard `datetime.datetime` object can be converted
 * to this format using [`strftime`](https://docs.python.org/2/library/time.html#time.strftime)
 * with the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one
 * can use the Joda Time's [`ISODateTimeFormat.dateTime()`](
 * http://www.joda.org/joda-time/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime--)
 * to obtain a formatter capable of generating timestamps in this format.
 * </pre>
 *
 * Protobuf type {@code google.protobuf.Timestamp}
 */
public  final class Timestamp extends
    com.github.os72.protobuf351.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.protobuf.Timestamp)
    TimestampOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Timestamp.newBuilder() to construct.
  private Timestamp(com.github.os72.protobuf351.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Timestamp() {
    seconds_ = 0L;
    nanos_ = 0;
  }

  @java.lang.Override
  public final com.github.os72.protobuf351.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Timestamp(
      com.github.os72.protobuf351.CodedInputStream input,
      com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
      throws com.github.os72.protobuf351.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.github.os72.protobuf351.UnknownFieldSet.Builder unknownFields =
        com.github.os72.protobuf351.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            seconds_ = input.readInt64();
            break;
          }
          case 16: {

            nanos_ = input.readInt32();
            break;
          }
        }
      }
    } catch (com.github.os72.protobuf351.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.github.os72.protobuf351.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.github.os72.protobuf351.Descriptors.Descriptor
      getDescriptor() {
    return com.github.os72.protobuf351.TimestampProto.internal_static_google_protobuf_Timestamp_descriptor;
  }

  protected com.github.os72.protobuf351.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.github.os72.protobuf351.TimestampProto.internal_static_google_protobuf_Timestamp_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.github.os72.protobuf351.Timestamp.class, com.github.os72.protobuf351.Timestamp.Builder.class);
  }

  public static final int SECONDS_FIELD_NUMBER = 1;
  private long seconds_;
  /**
   * <pre>
   * Represents seconds of UTC time since Unix epoch
   * 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
   * 9999-12-31T23:59:59Z inclusive.
   * </pre>
   *
   * <code>int64 seconds = 1;</code>
   */
  public long getSeconds() {
    return seconds_;
  }

  public static final int NANOS_FIELD_NUMBER = 2;
  private int nanos_;
  /**
   * <pre>
   * Non-negative fractions of a second at nanosecond resolution. Negative
   * second values with fractions must still have non-negative nanos values
   * that count forward in time. Must be from 0 to 999,999,999
   * inclusive.
   * </pre>
   *
   * <code>int32 nanos = 2;</code>
   */
  public int getNanos() {
    return nanos_;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.github.os72.protobuf351.CodedOutputStream output)
                      throws java.io.IOException {
    if (seconds_ != 0L) {
      output.writeInt64(1, seconds_);
    }
    if (nanos_ != 0) {
      output.writeInt32(2, nanos_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (seconds_ != 0L) {
      size += com.github.os72.protobuf351.CodedOutputStream
        .computeInt64Size(1, seconds_);
    }
    if (nanos_ != 0) {
      size += com.github.os72.protobuf351.CodedOutputStream
        .computeInt32Size(2, nanos_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.github.os72.protobuf351.Timestamp)) {
      return super.equals(obj);
    }
    com.github.os72.protobuf351.Timestamp other = (com.github.os72.protobuf351.Timestamp) obj;

    boolean result = true;
    result = result && (getSeconds()
        == other.getSeconds());
    result = result && (getNanos()
        == other.getNanos());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + com.github.os72.protobuf351.Internal.hashLong(
        getSeconds());
    hash = (37 * hash) + NANOS_FIELD_NUMBER;
    hash = (53 * hash) + getNanos();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.github.os72.protobuf351.Timestamp parseFrom(
      java.nio.ByteBuffer data)
      throws com.github.os72.protobuf351.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(
      java.nio.ByteBuffer data,
      com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
      throws com.github.os72.protobuf351.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(
      com.github.os72.protobuf351.ByteString data)
      throws com.github.os72.protobuf351.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(
      com.github.os72.protobuf351.ByteString data,
      com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
      throws com.github.os72.protobuf351.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(byte[] data)
      throws com.github.os72.protobuf351.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(
      byte[] data,
      com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
      throws com.github.os72.protobuf351.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.github.os72.protobuf351.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(
      java.io.InputStream input,
      com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.github.os72.protobuf351.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.github.os72.protobuf351.Timestamp parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.github.os72.protobuf351.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.github.os72.protobuf351.Timestamp parseDelimitedFrom(
      java.io.InputStream input,
      com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.github.os72.protobuf351.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(
      com.github.os72.protobuf351.CodedInputStream input)
      throws java.io.IOException {
    return com.github.os72.protobuf351.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.github.os72.protobuf351.Timestamp parseFrom(
      com.github.os72.protobuf351.CodedInputStream input,
      com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.github.os72.protobuf351.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.github.os72.protobuf351.Timestamp prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.github.os72.protobuf351.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A Timestamp represents a point in time independent of any time zone
   * or calendar, represented as seconds and fractions of seconds at
   * nanosecond resolution in UTC Epoch time. It is encoded using the
   * Proleptic Gregorian Calendar which extends the Gregorian calendar
   * backwards to year one. It is encoded assuming all minutes are 60
   * seconds long, i.e. leap seconds are "smeared" so that no leap second
   * table is needed for interpretation. Range is from
   * 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z.
   * By restricting to that range, we ensure that we can convert to
   * and from  RFC 3339 date strings.
   * See [https://www.ietf.org/rfc/rfc3339.txt](https://www.ietf.org/rfc/rfc3339.txt).
   * # Examples
   * Example 1: Compute Timestamp from POSIX `time()`.
   *     Timestamp timestamp;
   *     timestamp.set_seconds(time(NULL));
   *     timestamp.set_nanos(0);
   * Example 2: Compute Timestamp from POSIX `gettimeofday()`.
   *     struct timeval tv;
   *     gettimeofday(&amp;tv, NULL);
   *     Timestamp timestamp;
   *     timestamp.set_seconds(tv.tv_sec);
   *     timestamp.set_nanos(tv.tv_usec * 1000);
   * Example 3: Compute Timestamp from Win32 `GetSystemTimeAsFileTime()`.
   *     FILETIME ft;
   *     GetSystemTimeAsFileTime(&amp;ft);
   *     UINT64 ticks = (((UINT64)ft.dwHighDateTime) &lt;&lt; 32) | ft.dwLowDateTime;
   *     // A Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z
   *     // is 11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z.
   *     Timestamp timestamp;
   *     timestamp.set_seconds((INT64) ((ticks / 10000000) - 11644473600LL));
   *     timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));
   * Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.
   *     long millis = System.currentTimeMillis();
   *     Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000)
   *         .setNanos((int) ((millis % 1000) * 1000000)).build();
   * Example 5: Compute Timestamp from current time in Python.
   *     timestamp = Timestamp()
   *     timestamp.GetCurrentTime()
   * # JSON Mapping
   * In JSON format, the Timestamp type is encoded as a string in the
   * [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the
   * format is "{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z"
   * where {year} is always expressed using four digits while {month}, {day},
   * {hour}, {min}, and {sec} are zero-padded to two digits each. The fractional
   * seconds, which can go up to 9 digits (i.e. up to 1 nanosecond resolution),
   * are optional. The "Z" suffix indicates the timezone ("UTC"); the timezone
   * is required, though only UTC (as indicated by "Z") is presently supported.
   * For example, "2017-01-15T01:30:15.01Z" encodes 15.01 seconds past
   * 01:30 UTC on January 15, 2017.
   * In JavaScript, one can convert a Date object to this format using the
   * standard [toISOString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString]
   * method. In Python, a standard `datetime.datetime` object can be converted
   * to this format using [`strftime`](https://docs.python.org/2/library/time.html#time.strftime)
   * with the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one
   * can use the Joda Time's [`ISODateTimeFormat.dateTime()`](
   * http://www.joda.org/joda-time/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime--)
   * to obtain a formatter capable of generating timestamps in this format.
   * </pre>
   *
   * Protobuf type {@code google.protobuf.Timestamp}
   */
  public static final class Builder extends
      com.github.os72.protobuf351.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.protobuf.Timestamp)
      com.github.os72.protobuf351.TimestampOrBuilder {
    public static final com.github.os72.protobuf351.Descriptors.Descriptor
        getDescriptor() {
      return com.github.os72.protobuf351.TimestampProto.internal_static_google_protobuf_Timestamp_descriptor;
    }

    protected com.github.os72.protobuf351.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.github.os72.protobuf351.TimestampProto.internal_static_google_protobuf_Timestamp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.github.os72.protobuf351.Timestamp.class, com.github.os72.protobuf351.Timestamp.Builder.class);
    }

    // Construct using com.github.os72.protobuf351.Timestamp.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.github.os72.protobuf351.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.github.os72.protobuf351.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      seconds_ = 0L;

      nanos_ = 0;

      return this;
    }

    public com.github.os72.protobuf351.Descriptors.Descriptor
        getDescriptorForType() {
      return com.github.os72.protobuf351.TimestampProto.internal_static_google_protobuf_Timestamp_descriptor;
    }

    public com.github.os72.protobuf351.Timestamp getDefaultInstanceForType() {
      return com.github.os72.protobuf351.Timestamp.getDefaultInstance();
    }

    public com.github.os72.protobuf351.Timestamp build() {
      com.github.os72.protobuf351.Timestamp result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.github.os72.protobuf351.Timestamp buildPartial() {
      com.github.os72.protobuf351.Timestamp result = new com.github.os72.protobuf351.Timestamp(this);
      result.seconds_ = seconds_;
      result.nanos_ = nanos_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.github.os72.protobuf351.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.github.os72.protobuf351.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.github.os72.protobuf351.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.github.os72.protobuf351.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.github.os72.protobuf351.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.github.os72.protobuf351.Message other) {
      if (other instanceof com.github.os72.protobuf351.Timestamp) {
        return mergeFrom((com.github.os72.protobuf351.Timestamp)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.github.os72.protobuf351.Timestamp other) {
      if (other == com.github.os72.protobuf351.Timestamp.getDefaultInstance()) return this;
      if (other.getSeconds() != 0L) {
        setSeconds(other.getSeconds());
      }
      if (other.getNanos() != 0) {
        setNanos(other.getNanos());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.github.os72.protobuf351.CodedInputStream input,
        com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.github.os72.protobuf351.Timestamp parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.github.os72.protobuf351.InvalidProtocolBufferException e) {
        parsedMessage = (com.github.os72.protobuf351.Timestamp) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private long seconds_ ;
    /**
     * <pre>
     * Represents seconds of UTC time since Unix epoch
     * 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     * 9999-12-31T23:59:59Z inclusive.
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     */
    public long getSeconds() {
      return seconds_;
    }
    /**
     * <pre>
     * Represents seconds of UTC time since Unix epoch
     * 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     * 9999-12-31T23:59:59Z inclusive.
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     */
    public Builder setSeconds(long value) {
      
      seconds_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Represents seconds of UTC time since Unix epoch
     * 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     * 9999-12-31T23:59:59Z inclusive.
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     */
    public Builder clearSeconds() {
      
      seconds_ = 0L;
      onChanged();
      return this;
    }

    private int nanos_ ;
    /**
     * <pre>
     * Non-negative fractions of a second at nanosecond resolution. Negative
     * second values with fractions must still have non-negative nanos values
     * that count forward in time. Must be from 0 to 999,999,999
     * inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     */
    public int getNanos() {
      return nanos_;
    }
    /**
     * <pre>
     * Non-negative fractions of a second at nanosecond resolution. Negative
     * second values with fractions must still have non-negative nanos values
     * that count forward in time. Must be from 0 to 999,999,999
     * inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     */
    public Builder setNanos(int value) {
      
      nanos_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Non-negative fractions of a second at nanosecond resolution. Negative
     * second values with fractions must still have non-negative nanos values
     * that count forward in time. Must be from 0 to 999,999,999
     * inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     */
    public Builder clearNanos() {
      
      nanos_ = 0;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.github.os72.protobuf351.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.github.os72.protobuf351.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.protobuf.Timestamp)
  }

  // @@protoc_insertion_point(class_scope:google.protobuf.Timestamp)
  private static final com.github.os72.protobuf351.Timestamp DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.github.os72.protobuf351.Timestamp();
  }

  public static com.github.os72.protobuf351.Timestamp getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.github.os72.protobuf351.Parser<Timestamp>
      PARSER = new com.github.os72.protobuf351.AbstractParser<Timestamp>() {
    public Timestamp parsePartialFrom(
        com.github.os72.protobuf351.CodedInputStream input,
        com.github.os72.protobuf351.ExtensionRegistryLite extensionRegistry)
        throws com.github.os72.protobuf351.InvalidProtocolBufferException {
      return new Timestamp(input, extensionRegistry);
    }
  };

  public static com.github.os72.protobuf351.Parser<Timestamp> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.github.os72.protobuf351.Parser<Timestamp> getParserForType() {
    return PARSER;
  }

  public com.github.os72.protobuf351.Timestamp getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

