/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.common;

import com.lti.civil.Image;
import com.lti.civil.VideoFormat;
import com.lti.civil.impl.common.VideoFormatImpl;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;

public class BufferedImageImage
implements Image {
    private final BufferedImage bufferedImage;
    private final VideoFormat format;
    private final long timestamp;
    private byte[] bytes;

    public BufferedImageImage(BufferedImage image, long timestamp) {
        this.bufferedImage = image;
        this.timestamp = timestamp;
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte && image.getColorModel() instanceof ComponentColorModel && image.getSampleModel() instanceof ComponentSampleModel) {
            ComponentColorModel componentColorModel = (ComponentColorModel)image.getColorModel();
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)image.getSampleModel();
            int[] offsets = componentSampleModel.getBandOffsets();
            if (offsets.length == 4 && offsets[0] == 2 && offsets[1] == 1 && offsets[2] == 0) {
                DataBufferByte dbb = (DataBufferByte)dataBuffer;
                this.bytes = dbb.getBankData()[0];
                this.format = new VideoFormatImpl(2, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), -1.0f);
                return;
            }
            if (offsets.length == 3 && offsets[0] == 2 && offsets[1] == 1 && offsets[2] == 0) {
                DataBufferByte dbb = (DataBufferByte)dataBuffer;
                this.bytes = dbb.getBankData()[0];
                this.format = new VideoFormatImpl(1, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), -1.0f);
                return;
            }
        }
        this.format = new VideoFormatImpl(1, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), -1.0f);
    }

    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        this.bytes = new byte[w * h * 3];
        WritableRaster raster = this.bufferedImage.getRaster();
        int[] pixelArray = new int[4];
        ComponentColorModel componentColorModel = (ComponentColorModel)this.bufferedImage.getColorModel();
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.bufferedImage.getSampleModel();
        int[] offsets = componentSampleModel.getBandOffsets();
        int off = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                raster.getPixel(x, y, pixelArray);
                this.bytes[off++] = (byte)pixelArray[2];
                this.bytes[off++] = (byte)pixelArray[1];
                this.bytes[off++] = (byte)pixelArray[0];
            }
        }
        return this.bytes;
    }

    public VideoFormat getFormat() {
        return this.format;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

