/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.swing;

import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.Image;
import com.lti.civil.awt.AWTImageConverter;
import com.lti.civil.swing.ImageFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;

public class CaptureFrame
extends ImageFrame {
    private CaptureSystem system;
    private CaptureStream captureStream;
    private final CaptureSystemFactory factory;
    private volatile boolean disposing = false;

    public static void main(String[] args) throws CaptureException {
        new CaptureFrame(DefaultCaptureSystemFactorySingleton.instance()).run();
    }

    public CaptureFrame(CaptureSystemFactory factory) {
        super("LTI-CIVIL");
        this.factory = factory;
    }

    public void run() throws CaptureException {
        this.initCapture();
        this.setSize(this.captureStream.getVideoFormat().getWidth(), this.captureStream.getVideoFormat().getHeight());
        this.setLocation(200, 200);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    CaptureFrame.this.disposeCapture();
                }
                catch (CaptureException e1) {
                    e1.printStackTrace();
                }
                System.exit(0);
            }
        });
        this.setVisible(true);
        this.pack();
        this.startCapture();
    }

    public void initCapture() throws CaptureException {
        block0: {
            this.system = this.factory.createCaptureSystem();
            this.system.init();
            List list = this.system.getCaptureDeviceInfoList();
            int i = 0;
            if (i >= list.size()) break block0;
            CaptureDeviceInfo info = (CaptureDeviceInfo)list.get(i);
            System.out.println("Device ID " + i + ": " + info.getDeviceID());
            System.out.println("Description " + i + ": " + info.getDescription());
            this.captureStream = this.system.openCaptureDeviceStream(info.getDeviceID());
            this.captureStream.setObserver(new MyCaptureObserver());
        }
    }

    public void startCapture() throws CaptureException {
        this.captureStream.start();
    }

    public void disposeCapture() throws CaptureException {
        this.disposing = true;
        if (this.captureStream != null) {
            System.out.println("disposeCapture: stopping capture stream...");
            this.captureStream.stop();
            System.out.println("disposeCapture: stopped capture stream.");
            this.captureStream.dispose();
            this.captureStream = null;
        }
        if (this.system != null) {
            this.system.dispose();
        }
        System.out.println("disposeCapture done.");
    }

    class MyCaptureObserver
    implements CaptureObserver {
        MyCaptureObserver() {
        }

        public void onError(CaptureStream sender, CaptureException e) {
            e.printStackTrace();
        }

        public void onNewImage(CaptureStream sender, Image image) {
            if (CaptureFrame.this.disposing) {
                return;
            }
            try {
                CaptureFrame.this.setImage(AWTImageConverter.toBufferedImage(image));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

