/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ImageFrame
extends JFrame {
    private ImageComponent ic = new ImageComponent();

    public void setImage(Image image) {
        this.ic.setImage(image);
    }

    public ImageFrame(String title) {
        super(title);
        this.getContentPane().add(this.ic);
    }

    public void setImageSize(int h, int w) {
        this.ic.setImageSize(new Dimension(h, w));
    }

    public class ImageComponent
    extends JComponent {
        private Image image;
        private Dimension size = new Dimension(0, 0);

        public void setImage(Image image) {
            SwingUtilities.invokeLater(new ImageRunnable(image));
        }

        public void setImageSize(Dimension newSize) {
            if (!newSize.equals(this.size)) {
                this.size = newSize;
                this.setSize(this.size);
                ImageFrame.this.pack();
            }
        }

        private synchronized void setImageInSwingThread(Image image) {
            this.image = image;
            Dimension newSize = new Dimension(image.getWidth(null), image.getHeight(null));
            this.setImageSize(newSize);
            this.repaint();
        }

        public ImageComponent() {
            this.setSize(this.size);
        }

        public synchronized void paint(Graphics g) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }

        public synchronized Dimension getPreferredSize() {
            return this.size;
        }

        private class ImageRunnable
        implements Runnable {
            private final Image newImage;

            public ImageRunnable(Image newImage) {
                this.newImage = newImage;
            }

            public void run() {
                ImageComponent.this.setImageInSwingThread(this.newImage);
            }
        }
    }
}

