/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen.nanohttpd;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class NanoHTTPD {
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    private int myTcpPort;
    protected File myFileDir;
    private static Hashtable theMimeTypes = new Hashtable();
    private static SimpleDateFormat gmtFrmt;
    private static final String LICENCE = "Copyright (C) 2001,2005 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";

    public Response serve(String uri, String method, Properties header, Properties parms) {
        String value;
        System.out.println(method + " '" + uri + "' ");
        Enumeration<?> e = header.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            System.out.println("  HDR: '" + value + "' = '" + header.getProperty(value) + "'");
        }
        e = parms.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            System.out.println("  PRM: '" + value + "' = '" + parms.getProperty(value) + "'");
        }
        return this.serveFile(uri, header, new File("."), true);
    }

    public NanoHTTPD(int port) throws IOException {
        this.myTcpPort = port;
        final ServerSocket ss = new ServerSocket(this.myTcpPort);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        new HTTPSession(ss.accept());
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public static void main(String[] args) {
        System.out.println("NanoHTTPD 1.02 (C) 2001,2005 Jarno Elonen\n(Command line options: [port] [--licence])\n");
        int lopt = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].toLowerCase().endsWith("licence")) continue;
            lopt = i;
            System.out.println("Copyright (C) 2001,2005 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
        }
        int port = 80;
        if (args.length > 0 && lopt != 0) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length > 1 && args[1].toLowerCase().endsWith("licence")) {
            System.out.println("Copyright (C) 2001,2005 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
        }
        NanoHTTPD nh = null;
        try {
            nh = new NanoHTTPD(port);
        }
        catch (IOException ioe) {
            System.err.println("Couldn't start server:\n" + ioe);
            System.exit(-1);
        }
        nh.myFileDir = new File("");
        System.out.println("Now serving files in port " + port + " from \"" + new File("").getAbsolutePath() + "\"");
        System.out.println("Hit Enter to stop.\n");
        try {
            System.in.read();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private String encodeUri(String uri) {
        String newUri = "";
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                newUri = newUri + "/";
                continue;
            }
            if (tok.equals(" ")) {
                newUri = newUri + "%20";
                continue;
            }
            try {
                newUri = newUri + URLEncoder.encode(tok, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return newUri;
    }

    public Response serveFile(String uri, Properties header, File homeDir, boolean allowDirectoryListing) {
        if (!homeDir.isDirectory()) {
            return new Response(HTTP_INTERNALERROR, MIME_PLAINTEXT, "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
        }
        if ((uri = uri.trim().replace(File.separatorChar, '/')).indexOf(63) >= 0) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        if (uri.startsWith("..") || uri.endsWith("..") || uri.indexOf("../") >= 0) {
            return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Won't serve ../ for security reasons.");
        }
        File f = new File(homeDir, uri);
        if (!f.exists()) {
            return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Error 404, file not found.");
        }
        if (f.isDirectory()) {
            if (!uri.endsWith("/")) {
                uri = uri + "/";
                Response r = new Response(HTTP_REDIRECT, MIME_HTML, "<html><body>Redirected: <a href=\"" + uri + "\">" + uri + "</a></body></html>");
                r.addHeader("Location", uri);
                return r;
            }
            if (new File(f, "index.html").exists()) {
                f = new File(homeDir, uri + "/index.html");
            } else if (new File(f, "index.htm").exists()) {
                f = new File(homeDir, uri + "/index.htm");
            } else {
                if (allowDirectoryListing) {
                    String u;
                    int slash;
                    String[] files = f.list();
                    String msg = "<html><body><h1>Directory " + uri + "</h1><br/>";
                    if (uri.length() > 1 && (slash = (u = uri.substring(0, uri.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
                        msg = msg + "<b><a href=\"" + uri.substring(0, slash + 1) + "\">..</a></b><br/>";
                    }
                    for (int i = 0; i < files.length; ++i) {
                        File curFile = new File(f, files[i]);
                        boolean dir = curFile.isDirectory();
                        if (dir) {
                            msg = msg + "<b>";
                            int n = i;
                            files[n] = files[n] + "/";
                        }
                        msg = msg + "<a href=\"" + this.encodeUri(uri + files[i]) + "\">" + files[i] + "</a>";
                        if (curFile.isFile()) {
                            long len = curFile.length();
                            msg = msg + " &nbsp;<font size=2>(";
                            msg = len < 1024L ? msg + curFile.length() + " bytes" : (len < 0x100000L ? msg + curFile.length() / 1024L + "." + curFile.length() % 1024L / 10L % 100L + " KB" : msg + curFile.length() / 0x100000L + "." + curFile.length() % 0x100000L / 10L % 100L + " MB");
                            msg = msg + ")</font>";
                        }
                        msg = msg + "<br/>";
                        if (!dir) continue;
                        msg = msg + "</b>";
                    }
                    return new Response(HTTP_OK, MIME_HTML, msg);
                }
                return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: No directory listing.");
            }
        }
        String mime = null;
        int dot = uri.lastIndexOf(46);
        if (dot >= 0) {
            mime = (String)theMimeTypes.get(uri.substring(dot + 1).toLowerCase());
        }
        if (mime == null) {
            mime = MIME_DEFAULT_BINARY;
        }
        try {
            long startFrom = 0L;
            String range = header.getProperty("Range");
            if (range != null && range.startsWith("bytes=")) {
                int minus = (range = range.substring("bytes=".length())).indexOf(45);
                if (minus > 0) {
                    range = range.substring(0, minus);
                }
                try {
                    startFrom = Long.parseLong(range);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            FileInputStream fis = new FileInputStream(f);
            fis.skip(startFrom);
            Response r = new Response(HTTP_OK, mime, fis);
            r.addHeader("Content-length", "" + (f.length() - startFrom));
            r.addHeader("Content-range", "" + startFrom + "-" + (f.length() - 1L) + "/" + f.length());
            return r;
        }
        catch (IOException ioe) {
            return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Reading file failed.");
        }
    }

    static {
        StringTokenizer st = new StringTokenizer("htm\t\ttext/html html\t\ttext/html txt\t\ttext/plain asc\t\ttext/plain gif\t\timage/gif jpg\t\timage/jpeg jpeg\t\timage/jpeg png\t\timage/png mp3\t\taudio/mpeg m3u\t\taudio/mpeg-url pdf\t\tapplication/pdf doc\t\tapplication/msword ogg\t\tapplication/x-ogg zip\t\tapplication/octet-stream exe\t\tapplication/octet-stream class\t\tapplication/octet-stream ");
        while (st.hasMoreTokens()) {
            theMimeTypes.put(st.nextToken(), st.nextToken());
        }
        gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class HTTPSession
    implements Runnable {
        private Socket mySocket;
        private BufferedReader myIn;

        public HTTPSession(Socket s) {
            this.mySocket = s;
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.start();
        }

        public void run() {
            try {
                Response r;
                InputStream is = this.mySocket.getInputStream();
                if (is == null) {
                    return;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                StringTokenizer st = new StringTokenizer(in.readLine());
                if (!st.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                String method = st.nextToken();
                if (!st.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                String uri = this.decodePercent(st.nextToken());
                Properties parms = new Properties();
                int qmi = uri.indexOf(63);
                if (qmi >= 0) {
                    this.decodeParms(uri.substring(qmi + 1), parms);
                    uri = this.decodePercent(uri.substring(0, qmi));
                }
                Properties header = new Properties();
                if (st.hasMoreTokens()) {
                    String line = in.readLine();
                    while (line.trim().length() > 0) {
                        int p = line.indexOf(58);
                        header.put(line.substring(0, p).trim(), line.substring(p + 1).trim());
                        line = in.readLine();
                    }
                }
                if (method.equalsIgnoreCase("POST")) {
                    this.decodeParms(in.readLine(), parms);
                }
                if ((r = NanoHTTPD.this.serve(uri, method, header, parms)) == null) {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                } else {
                    this.sendResponse(r.status, r.mimeType, r.header, r.data);
                }
                in.close();
            }
            catch (IOException ioe) {
                try {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                }
                catch (Throwable throwable) {}
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private String decodePercent(String str) throws InterruptedException {
            try {
                StringBuffer sb = new StringBuffer();
                block6: for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    switch (c) {
                        case '+': {
                            sb.append(' ');
                            continue block6;
                        }
                        case '%': {
                            sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                            i += 2;
                            continue block6;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return new String(sb.toString().getBytes());
            }
            catch (Exception e) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Bad percent-encoding.");
                return null;
            }
        }

        private void decodeParms(String parms, Properties p) throws InterruptedException {
            if (parms == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                if (sep < 0) continue;
                p.put(this.decodePercent(e.substring(0, sep)).trim(), this.decodePercent(e.substring(sep + 1)));
            }
        }

        private void sendError(String status, String msg) throws InterruptedException {
            this.sendResponse(status, NanoHTTPD.MIME_PLAINTEXT, null, new ByteArrayInputStream(msg.getBytes()));
            throw new InterruptedException();
        }

        private void sendResponse(String status, String mime, Properties header, InputStream data) {
            try {
                if (status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                OutputStream out = this.mySocket.getOutputStream();
                PrintWriter pw = new PrintWriter(out);
                pw.print("HTTP/1.0 " + status + " \r\n");
                if (mime != null) {
                    pw.print("Content-Type: " + mime + "\r\n");
                }
                if (header == null || header.getProperty("Date") == null) {
                    pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                }
                if (header != null) {
                    Enumeration<Object> e = header.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = header.getProperty(key);
                        pw.print(key + ": " + value + "\r\n");
                    }
                }
                pw.print("\r\n");
                pw.flush();
                if (data != null) {
                    int read;
                    byte[] buff = new byte[2048];
                    while ((read = data.read(buff, 0, 2048)) > 0) {
                        out.write(buff, 0, read);
                    }
                }
                out.flush();
                out.close();
                if (data != null) {
                    data.close();
                }
            }
            catch (IOException ioe) {
                try {
                    this.mySocket.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    public class Response {
        public String status;
        public String mimeType;
        public InputStream data;
        public Properties header = new Properties();

        public Response() {
            this.status = NanoHTTPD.HTTP_OK;
        }

        public Response(String status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(String status, String mimeType, String txt) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = new ByteArrayInputStream(txt.getBytes());
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }
    }
}

