/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.BaseVideoFrame;
import au.edu.jcu.v4l4j.CaptureCallback;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.FrameInterval;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.PushSource;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.CaptureChannelException;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.InvalidValue;
import au.edu.jcu.v4l4j.exceptions.NoTunerException;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import au.edu.jcu.v4l4j.exceptions.VideoStandardException;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;

abstract class AbstractGrabber
implements FrameGrabber {
    protected static final int RAW_GRABBER = 0;
    protected static final int JPEG_GRABBER = 1;
    protected static final int RGB24_GRABBER = 2;
    protected static final int BGR24_GRABBER = 3;
    protected static final int YUV_GRABBER = 4;
    protected static final int YVU_GRABBER = 5;
    protected DeviceInfo dInfo;
    private int width;
    private int height;
    private int channel;
    private int standard;
    protected int nbV4LBuffers;
    protected Vector<BaseVideoFrame> videoFrames;
    private Vector<BaseVideoFrame> availableVideoFrames;
    protected State state;
    protected int format;
    private Tuner tuner;
    private int type;
    private long lastCapturedFrameSequence;
    private long lastCapturedFrameTimeuSec;
    private int lastCapturedFrameBufferIndex;
    private PushSource pushSource;
    private ThreadFactory threadFactory;
    protected long object;

    private native int doInit(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9) throws V4L4JException;

    private native void start(long var1) throws V4L4JException;

    protected native void setQuality(long var1, int var3);

    private native int getBufferSize(long var1);

    private native int enqueueBuffer(long var1, int var3);

    private native int fillBuffer(long var1, byte[] var3) throws V4L4JException;

    private native void stop(long var1);

    private native void doRelease(long var1);

    private native void doSetFrameIntv(long var1, int var3, int var4) throws InvalidValue;

    private native int doGetFrameIntv(long var1, int var3);

    private native void doSetVideoInputNStandard(long var1, int var3, int var4);

    private native int doGetVideoInput(long var1);

    private native int doGetVideoStandard(long var1);

    protected AbstractGrabber(DeviceInfo di, long o, int w, int h, int ch, int std, Tuner t, ImageFormat imf, int ty, ThreadFactory factory) throws ImageFormatException {
        if (imf == null) {
            throw new ImageFormatException("The image format can not be null");
        }
        this.state = new State();
        this.dInfo = di;
        this.object = o;
        this.width = w;
        this.height = h;
        this.channel = ch;
        this.standard = std;
        this.format = imf.getIndex();
        this.tuner = t;
        this.type = ty;
        this.nbV4LBuffers = System.getProperty("v4l4j.num_driver_buffers") != null ? Integer.parseInt(System.getProperty("v4l4j.num_driver_buffers")) : 4;
        this.videoFrames = new Vector();
        this.availableVideoFrames = new Vector();
        this.pushSource = null;
        this.threadFactory = factory;
    }

    void init() throws V4L4JException {
        this.state.init();
        this.nbV4LBuffers = this.doInit(this.object, this.nbV4LBuffers, this.width, this.height, this.channel, this.standard, this.format, this.type);
        int bufferSize = this.getBufferSize(this.object);
        this.createBuffers(bufferSize);
        this.state.commit();
    }

    protected abstract void createBuffers(int var1);

    @Override
    public int getNumberOfVideoFrames() {
        return this.nbV4LBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfRecycledVideoFrames() {
        Vector<BaseVideoFrame> vector = this.availableVideoFrames;
        synchronized (vector) {
            return this.availableVideoFrames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrameInterval(int num, int denom) throws InvalidValue {
        State state = this.state;
        synchronized (state) {
            if (this.state.isStarted()) {
                throw new StateException("Invalid method call");
            }
            this.doSetFrameIntv(this.object, num, denom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameInterval.DiscreteInterval getFrameInterval() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isStarted()) {
                throw new StateException("Invalid method call: cannot get the frame interval while capturing.");
            }
            return new FrameInterval.DiscreteInterval(this.doGetFrameIntv(this.object, 0), this.doGetFrameIntv(this.object, 1));
        }
    }

    @Override
    public void setVideoInputNStandard(int input, int standard) throws VideoStandardException, CaptureChannelException {
        this.state.checkReleased();
        this.doSetVideoInputNStandard(this.object, input, standard);
    }

    @Override
    public int getVideoInput() {
        this.state.checkReleased();
        return this.doGetVideoInput(this.object);
    }

    @Override
    public int getVideoStandard() {
        this.state.checkReleased();
        return this.doGetVideoStandard(this.object);
    }

    @Override
    public final Tuner getTuner() throws NoTunerException {
        if (this.tuner == null) {
            throw new NoTunerException("This input does not have a tuner");
        }
        this.state.checkReleased();
        return this.tuner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCaptureCallback(CaptureCallback callback) {
        if (callback == null) {
            throw new NullPointerException("The callback object cannot be null");
        }
        State state = this.state;
        synchronized (state) {
            if (this.state.isStarted()) {
                throw new StateException("This frame grabber is already started");
            }
            this.pushSource = new PushSource(this, callback, this.threadFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startCapture() throws V4L4JException {
        this.state.start();
        if (this.pushSource == null) {
            this.state.rollback();
            throw new V4L4JException("setCaptureCallback() must be called with a valid callback object before startCapture()");
        }
        this.pushSource.startCapture();
        this.state.waitForAtLeastOneUser();
        try {
            this.start(this.object);
        }
        catch (V4L4JException e) {
            this.pushSource.stopCapture();
            this.state.rollback();
            throw e;
        }
        this.state.commit();
        Vector<BaseVideoFrame> vector = this.availableVideoFrames;
        synchronized (vector) {
            this.availableVideoFrames.addAll(this.videoFrames);
            this.availableVideoFrames.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseVideoFrame getAvailableVideoFrame() {
        BaseVideoFrame frame = null;
        Vector<BaseVideoFrame> vector = this.availableVideoFrames;
        synchronized (vector) {
            while (this.availableVideoFrames.size() == 0) {
                try {
                    this.availableVideoFrames.wait();
                }
                catch (InterruptedException e) {
                    throw new StateException("Interrupted while waiting for a video frame", e);
                }
            }
            frame = this.availableVideoFrames.remove(0);
        }
        return frame;
    }

    final VideoFrame getNextVideoFrame() throws V4L4JException {
        BaseVideoFrame nextFrame;
        this.state.get();
        try {
            nextFrame = this.getAvailableVideoFrame();
            int frameSize = this.fillBuffer(this.object, nextFrame.getByteArray());
            nextFrame.prepareForDelivery(frameSize, this.lastCapturedFrameBufferIndex, this.lastCapturedFrameSequence, this.lastCapturedFrameTimeuSec);
        }
        finally {
            this.state.put();
        }
        return nextFrame;
    }

    static synchronized void Log(String s) {
        System.out.println(Thread.currentThread().getName() + ": " + s);
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void recycleVideoBuffer(BaseVideoFrame frame) {
        if (this.state.isStarted()) {
            this.enqueueBuffer(this.object, frame.getBufferInex());
            Vector<BaseVideoFrame> vector = this.availableVideoFrames;
            synchronized (vector) {
                this.availableVideoFrames.add(frame);
                this.availableVideoFrames.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopCapture() {
        this.state.stop();
        this.pushSource.stopCapture();
        this.stop(this.object);
        this.state.waitTillNoMoreUsers();
        for (VideoFrame videoFrame : this.videoFrames) {
            videoFrame.recycle();
        }
        Vector<BaseVideoFrame> vector = this.availableVideoFrames;
        synchronized (vector) {
            this.availableVideoFrames.removeAllElements();
        }
        this.state.commit();
    }

    final void release() {
        try {
            this.stopCapture();
        }
        catch (StateException stateException) {
            // empty catch block
        }
        this.state.release();
        this.doRelease(this.object);
        this.state.commit();
    }

    @Override
    public final int getHeight() {
        this.state.checkReleased();
        return this.height;
    }

    @Override
    public final int getWidth() {
        this.state.checkReleased();
        return this.width;
    }

    @Override
    public final int getChannel() {
        this.state.checkReleased();
        return this.channel;
    }

    @Override
    public final int getStandard() {
        this.state.checkReleased();
        return this.standard;
    }

    final boolean isStarted() {
        return this.state.isStarted();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dInfo == null ? 0 : this.dInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractGrabber)) {
            return false;
        }
        AbstractGrabber other = (AbstractGrabber)obj;
        return !(this.dInfo == null ? other.dInfo != null : !this.dInfo.equals(other.dInfo));
    }

    static {
        try {
            System.loadLibrary("v4l4j");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Cant load v4l4j JNI library");
            throw e;
        }
    }

    protected static class State {
        private int state = UNINIT;
        private int temp = UNINIT;
        private int users = 0;
        private static int UNINIT = 0;
        private static int INIT = 1;
        private static int STARTED = 2;
        private static int STOPPED = 3;
        private static int RELEASED = 4;

        public synchronized void init() {
            if (this.state != UNINIT || this.temp == INIT) {
                throw new StateException("This FrameGrabber can not be initialised again");
            }
            this.temp = INIT;
        }

        public synchronized void start() {
            if (this.state != INIT && (this.state != STOPPED || this.temp == STARTED)) {
                throw new StateException("This FrameGrabber is not initialised or stopped and can not be started");
            }
            this.temp = STARTED;
        }

        public boolean isStarted() {
            this.checkReleased();
            return this.state == STARTED && this.temp != STOPPED;
        }

        public void checkReleased() {
            if (this.state == RELEASED || this.temp == RELEASED) {
                throw new StateException("This FrameGrabber has been released");
            }
        }

        public synchronized void get() {
            if (this.users == 0) {
                this.notify();
            }
            ++this.users;
        }

        public synchronized void waitForAtLeastOneUser() {
            while (this.users == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    System.err.println("Interrupted while waiting for push thread to start");
                    e.printStackTrace();
                    throw new StateException("Interrupted while waiting forpush thread to start");
                }
            }
        }

        public synchronized void put() {
            if (--this.users == 0) {
                this.notify();
            }
            if (this.temp == STOPPED) {
                throw new StateException("This framegrabber was stopped");
            }
        }

        public synchronized void stop() {
            if (this.state != STARTED || this.temp == STOPPED) {
                throw new StateException("This FrameGrabber is not started and can not be stopped");
            }
            this.temp = STOPPED;
        }

        public synchronized void waitTillNoMoreUsers() {
            while (this.users != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void release() {
            if (this.state != INIT && (this.state != STOPPED || this.temp == RELEASED)) {
                throw new StateException("This FrameGrabber is neither initialised nor stopped and can not be released");
            }
            this.temp = RELEASED;
        }

        public synchronized void commit() {
            this.state = this.temp;
        }

        public synchronized void rollback() {
            this.temp = this.state;
        }
    }
}

