/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.UncompressedVideoFrame;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.awt.color.ColorSpace;
import java.awt.image.PixelInterleavedSampleModel;
import java.util.concurrent.ThreadFactory;

public class BGRFrameGrabber
extends AbstractGrabber {
    BGRFrameGrabber(DeviceInfo di, long o, int w, int h, int ch, int std, Tuner t, ImageFormat imf, ThreadFactory factory) throws ImageFormatException {
        super(di, o, w, h, ch, std, t, imf, 3, factory);
    }

    @Override
    void init() throws V4L4JException {
        try {
            super.init();
        }
        catch (ImageFormatException ife) {
            if (this.format == -1) {
                String msg = "v4l4j was unable to find image format supported by the \nvideo device and that can be converted to BGR24.\nPlease let the author know about this, so that support\nfor this video device can be improved. See \nREADME file on how to submit v4l4j reports.";
                System.err.println(msg);
                ife = new ImageFormatException(msg);
            }
            throw ife;
        }
    }

    @Override
    public ImageFormat getImageFormat() {
        this.state.checkReleased();
        return this.dInfo.getFormatList().getBGREncodableFormat(this.format);
    }

    @Override
    protected void createBuffers(int bufferSize) {
        int numberOfBuffers = this.nbV4LBuffers;
        ColorSpace cs = ColorSpace.getInstance(1000);
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, this.getWidth(), this.getHeight(), 3, this.getWidth() * 3, new int[]{2, 1, 0});
        while (numberOfBuffers-- > 0) {
            this.videoFrames.add(new UncompressedVideoFrame(this, bufferSize, sm, cs));
        }
    }
}

