/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.exceptions.ControlException;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Control {
    private int id;
    private String name;
    private int max;
    private int min;
    private int step;
    private int type;
    private Vector<String> names;
    private int[] values;
    private long v4l4jObject;
    private int defaultValue;
    private State state;

    private native int doGetValue(long var1, int var3) throws ControlException;

    private native int doSetValue(long var1, int var3, int var4) throws ControlException;

    private native String doGetStringValue(long var1, int var3) throws ControlException;

    private native void doSetStringValue(long var1, int var3, String var4) throws ControlException;

    private native long doGetLongValue(long var1, int var3) throws ControlException;

    private native int doSetLongValue(long var1, int var3, long var4) throws ControlException;

    Control(int id, String name, int min, int max, int step, int type, String[] names, int[] values, long o) {
        this.id = id;
        this.name = new String(name);
        this.min = min;
        this.max = max;
        this.step = step;
        this.type = type;
        if (names != null) {
            this.names = new Vector();
            for (String s : names) {
                this.names.add(s);
            }
        }
        this.values = values;
        this.defaultValue = min <= 0 && 0 <= max ? 0 : (int)Math.round((double)(max - min) / 2.0) + min;
        this.v4l4jObject = o;
        this.state = new State();
    }

    public int getValue() throws ControlException {
        int v = 0;
        if (this.type == 4) {
            throw new UnsupportedMethod("This control is a string control and does not accept calls to getValue()");
        }
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to setValue()");
        }
        this.state.get();
        if (this.type == 0) {
            this.state.put();
            return 0;
        }
        try {
            v = this.doGetValue(this.v4l4jObject, this.id);
        }
        catch (ControlException ce) {
            this.state.put();
            throw ce;
        }
        this.state.put();
        return v;
    }

    public int setValue(int value) throws ControlException {
        int v = this.defaultValue;
        if (this.type == 4) {
            throw new UnsupportedMethod("This control is a string control and does not support calls to setValue()");
        }
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to setValue()");
        }
        this.state.get();
        value = this.type == 0 ? 0 : this.validateValue(value);
        try {
            this.doSetValue(this.v4l4jObject, this.id, value);
        }
        catch (ControlException ce) {
            this.state.put();
            throw ce;
        }
        try {
            v = this.getValue();
        }
        catch (ControlException controlException) {
            // empty catch block
        }
        this.state.put();
        return v;
    }

    public String getStringValue() throws ControlException {
        String v;
        if (this.type != 4) {
            throw new UnsupportedMethod("This control is not a string control");
        }
        this.state.get();
        try {
            v = this.doGetStringValue(this.v4l4jObject, this.id);
        }
        finally {
            this.state.put();
        }
        return v;
    }

    public String setStringValue(String value) throws ControlException {
        String v = null;
        if (this.type != 4) {
            throw new UnsupportedMethod("This control is not a string control");
        }
        if (value.length() > this.max) {
            throw new ControlException("The new string value for this control exceeds the maximum length");
        }
        if (value.length() < this.min) {
            throw new ControlException("The new string value for this control is below the minimum length");
        }
        this.state.get();
        try {
            this.doSetStringValue(this.v4l4jObject, this.id, value);
            v = this.doGetStringValue(this.v4l4jObject, this.id);
        }
        finally {
            this.state.put();
        }
        return v;
    }

    public long getLongValue() throws ControlException {
        long v;
        if (this.type != 5) {
            throw new UnsupportedMethod("This control is not a long control");
        }
        this.state.get();
        try {
            v = this.doGetLongValue(this.v4l4jObject, this.id);
        }
        finally {
            this.state.put();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setLongValue(long value) throws ControlException {
        long v = 0L;
        if (this.type != 5) {
            throw new UnsupportedMethod("This control is not a long control");
        }
        this.state.get();
        try {
            this.doSetLongValue(this.v4l4jObject, this.id, value);
            v = this.doGetLongValue(this.v4l4jObject, this.id);
        }
        finally {
            this.state.put();
        }
        return v;
    }

    public int increaseValue() throws ControlException {
        int old = this.defaultValue;
        if (this.type == 4) {
            throw new UnsupportedMethod("This control is a string control and does not accept calls to increaseValue()");
        }
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to increaseValue()");
        }
        this.state.get();
        try {
            old = this.doGetValue(this.v4l4jObject, this.id);
        }
        catch (ControlException e) {
            // empty catch block
        }
        try {
            old = this.doSetValue(this.v4l4jObject, this.id, this.validateValue(old + this.step));
        }
        catch (ControlException ce) {
            this.state.put();
            throw ce;
        }
        this.state.put();
        return old;
    }

    public int decreaseValue() throws ControlException {
        int old = this.defaultValue;
        if (this.type == 4) {
            throw new UnsupportedMethod("This control is a string control and does not support calls to decreaseValue()");
        }
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to decreaseValue()");
        }
        this.state.get();
        try {
            old = this.doGetValue(this.v4l4jObject, this.id);
        }
        catch (ControlException e) {
            // empty catch block
        }
        try {
            old = this.doSetValue(this.v4l4jObject, this.id, this.validateValue(old - this.step));
        }
        catch (ControlException ce) {
            this.state.put();
            throw ce;
        }
        this.state.put();
        return old;
    }

    public int getMaxValue() {
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to getMaxValue()");
        }
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.max;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getMinValue() {
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to getMinValue()");
        }
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.min;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public String getName() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.name;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getStepValue() {
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to getStepValue()");
        }
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.step;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getType() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.type;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getDefaultValue() {
        if (this.type == 4) {
            throw new UnsupportedMethod("This control is a string control and does not support calls to getDefaultValue()");
        }
        if (this.type == 5) {
            throw new UnsupportedMethod("This control is a long control and does not support calls to getDefaultValue()");
        }
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.defaultValue;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public List<Integer> getDiscreteValues() {
        if (this.type != 3 || this.values == null) {
            throw new UnsupportedMethod("This control does not accept discrete values");
        }
        this.state.get();
        Vector<Integer> v = new Vector<Integer>();
        for (int i : this.values) {
            v.add(new Integer(i));
        }
        this.state.put();
        return v;
    }

    public List<String> getDiscreteValueNames() {
        if (this.type != 3 || this.names == null) {
            throw new UnsupportedMethod("This control does not have discrete values");
        }
        this.state.get();
        Vector<String> v = new Vector<String>(this.names);
        this.state.put();
        return v;
    }

    public Map<String, Integer> getDiscreteValuesMap() {
        if (this.type != 3 || this.names == null) {
            throw new UnsupportedMethod("This control does not have discrete values");
        }
        this.state.get();
        Hashtable<String, Integer> t = new Hashtable<String, Integer>();
        for (int i = 0; i < this.names.size(); ++i) {
            t.put(this.names.get(i), this.values[i]);
        }
        this.state.put();
        return t;
    }

    void release() {
        this.state.release();
    }

    private int validateValue(int val) throws ControlException {
        if (val < this.min || val > this.max) {
            throw new ControlException("The value '" + val + "' is outside the allowed range");
        }
        return val;
    }

    private class State {
        private int state = this.INIT;
        private int temp = this.INIT;
        private int users = 0;
        private int INIT = 0;
        private int RELEASED = 1;

        public synchronized void get() {
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                ++this.users;
            } else {
                throw new StateException("This Control has been released and must not be used");
            }
        }

        public synchronized void put() {
            if (this.state == this.INIT) {
                if (--this.users == 0 && this.temp == this.RELEASED) {
                    this.notify();
                }
            } else {
                throw new StateException("This Control has been released and must not be used");
            }
        }

        public boolean isNotReleased() {
            return this.state == this.INIT && this.temp != this.RELEASED;
        }

        public synchronized void release() {
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                this.temp = this.RELEASED;
                while (this.users != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        System.err.println("Interrupted while waiting for Control users to complete");
                        e.printStackTrace();
                        throw new StateException("There are remaining users of this Control and it can not be stopped");
                    }
                }
            }
        }

        public synchronized void commit() {
            this.state = this.temp;
        }
    }
}

