/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.util.List;
import java.util.Vector;

public class FrameInterval {
    private final Type type;
    private List<DiscreteInterval> discreteValues;
    private StepwiseInterval stepwiseInterval;

    private native int doGetFrameIntvType(int var1, long var2);

    private native void doGetDiscrete(int var1, long var2);

    private native void doGetStepwise(int var1, long var2);

    FrameInterval(int ptr_type, long o) {
        int frameIntvType;
        switch (ptr_type) {
            case 3: {
                frameIntvType = 0;
                break;
            }
            case 4: {
                frameIntvType = 1;
                break;
            }
            case 5: {
                frameIntvType = 2;
                break;
            }
            default: {
                try {
                    frameIntvType = this.doGetFrameIntvType(ptr_type, o);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("There was an error checking the supported interval types.\nPlease report this error to thev4l4j mailing list.\nSee REAME file for information on reporting bugs");
                    this.type = Type.UNSUPPORTED;
                    return;
                }
            }
        }
        try {
            if (frameIntvType == 1) {
                this.discreteValues = new Vector<DiscreteInterval>();
                this.doGetDiscrete(ptr_type, o);
            } else if (frameIntvType == 2) {
                this.doGetStepwise(ptr_type, o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("There was an error checking the supported intervals.\nPlease report this error to thev4l4j mailing list.\nSee REAME file for information on reporting bugs");
            this.type = Type.UNSUPPORTED;
            return;
        }
        this.type = frameIntvType == 0 ? Type.UNSUPPORTED : (frameIntvType == 1 ? Type.DISCRETE : Type.STEPWISE);
    }

    public Type getType() {
        return this.type;
    }

    public List<DiscreteInterval> getDiscreteIntervals() {
        if (this.type != Type.DISCRETE) {
            throw new UnsupportedMethod("Supported intervals are not discrete");
        }
        return new Vector<DiscreteInterval>(this.discreteValues);
    }

    public StepwiseInterval getStepwiseInterval() {
        if (this.type != Type.STEPWISE) {
            throw new UnsupportedMethod("Supported interval is not continuous");
        }
        return this.stepwiseInterval;
    }

    public String toString() {
        String s;
        if (this.type == Type.DISCRETE) {
            s = "";
            for (DiscreteInterval i : this.discreteValues) {
                s = s + i.toString() + " - ";
            }
        } else {
            s = this.type == Type.STEPWISE ? this.stepwiseInterval.toString() : "no frame interval information";
        }
        return s;
    }

    public static class StepwiseInterval {
        public final DiscreteInterval minIntv;
        public final DiscreteInterval maxIntv;
        public final DiscreteInterval stepIntv;

        private StepwiseInterval(int minN, int minD, int maxN, int maxD, int stepN, int stepD) {
            this.minIntv = new DiscreteInterval(minN, minD);
            this.maxIntv = new DiscreteInterval(maxN, maxD);
            this.stepIntv = new DiscreteInterval(stepN, stepD);
        }

        public DiscreteInterval getMinInterval() {
            return this.minIntv;
        }

        public DiscreteInterval getMaxInterval() {
            return this.maxIntv;
        }

        public DiscreteInterval getStepInterval() {
            return this.stepIntv;
        }

        public String toString() {
            return this.minIntv + " - " + this.maxIntv + " - " + this.stepIntv;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.maxIntv == null ? 0 : this.maxIntv.hashCode());
            result = 31 * result + (this.minIntv == null ? 0 : this.minIntv.hashCode());
            result = 31 * result + (this.stepIntv == null ? 0 : this.stepIntv.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StepwiseInterval)) {
                return false;
            }
            StepwiseInterval other = (StepwiseInterval)obj;
            if (this.maxIntv == null ? other.maxIntv != null : !this.maxIntv.equals(other.maxIntv)) {
                return false;
            }
            if (this.minIntv == null ? other.minIntv != null : !this.minIntv.equals(other.minIntv)) {
                return false;
            }
            return !(this.stepIntv == null ? other.stepIntv != null : !this.stepIntv.equals(other.stepIntv));
        }
    }

    public static class DiscreteInterval {
        public final int numerator;
        public final int denominator;

        DiscreteInterval(int n, int d) {
            this.numerator = n;
            this.denominator = d;
        }

        public int getNum() {
            return this.numerator;
        }

        public int getDenom() {
            return this.denominator;
        }

        public String toString() {
            return this.numerator + "/" + this.denominator;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.denominator;
            result = 31 * result + this.numerator;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DiscreteInterval)) {
                return false;
            }
            DiscreteInterval other = (DiscreteInterval)obj;
            if (this.denominator != other.denominator) {
                return false;
            }
            return this.numerator == other.numerator;
        }
    }

    public static enum Type {
        UNSUPPORTED,
        DISCRETE,
        STEPWISE;

    }
}

