/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.ImageFormat;
import java.util.List;
import java.util.Vector;

public class ImageFormatList {
    private List<ImageFormat> formats = new Vector<ImageFormat>();
    private List<ImageFormat> JPEGformats = new Vector<ImageFormat>();
    private List<ImageFormat> RGBformats = new Vector<ImageFormat>();
    private List<ImageFormat> BGRformats = new Vector<ImageFormat>();
    private List<ImageFormat> YUV420formats = new Vector<ImageFormat>();
    private List<ImageFormat> YVU420formats = new Vector<ImageFormat>();

    private native void listFormats(long var1);

    ImageFormatList(long o) {
        this.listFormats(o);
        this.sortLists();
    }

    private void sortLists() {
        this.moveToFirstIfNative(this.RGBformats, 7);
        this.moveToFirstIfNative(this.BGRformats, 6);
        this.moveToFirstIfNative(this.YUV420formats, 31);
        this.moveToFirstIfNative(this.YVU420formats, 17);
        this.moveNativeFirst(this.JPEGformats);
        this.moveToFirstIfNative(this.JPEGformats, 9);
        this.moveToFirstIfNative(this.JPEGformats, 7);
        this.moveToFirstIfNative(this.JPEGformats, 21);
        this.moveToFirstIfNative(this.JPEGformats, 18);
        this.moveToFirstIfNative(this.JPEGformats, 31);
        this.moveToFirstIfNative(this.JPEGformats, 48);
        this.moveToFirstIfNative(this.JPEGformats, 49);
    }

    private void moveToFirstIfNative(List<ImageFormat> v, int format) {
        for (ImageFormat i : v) {
            if (i.getIndex() != format || !this.formats.contains(i)) continue;
            v.remove(i);
            v.add(0, i);
            break;
        }
    }

    private void moveToFirst(List<ImageFormat> v, int format) {
        for (ImageFormat i : v) {
            if (i.getIndex() != format) continue;
            v.remove(i);
            v.add(0, i);
            break;
        }
    }

    private void moveNativeFirst(List<ImageFormat> v) {
        int index = 0;
        for (int i = 0; i < v.size(); ++i) {
            if (!this.formats.contains(v.get(index))) {
                v.add(v.remove(index));
                continue;
            }
            ++index;
        }
    }

    private ImageFormat getFormat(List<ImageFormat> l, String n) {
        for (ImageFormat f : l) {
            if (!f.getName().equals(n)) continue;
            return f;
        }
        return null;
    }

    private ImageFormat getFormat(List<ImageFormat> l, int i) {
        for (ImageFormat f : l) {
            if (f.getIndex() != i) continue;
            return f;
        }
        return null;
    }

    public List<ImageFormat> getNativeFormats() {
        return new Vector<ImageFormat>(this.formats);
    }

    public ImageFormat getNativeFormat(String n) {
        return this.getFormat(this.formats, n);
    }

    public ImageFormat getNativeFormat(int i) {
        return this.getFormat(this.formats, i);
    }

    public List<ImageFormat> getJPEGEncodableFormats() {
        return new Vector<ImageFormat>(this.JPEGformats);
    }

    public ImageFormat getJPEGEncodableFormat(String n) {
        return this.getFormat(this.JPEGformats, n);
    }

    public ImageFormat getJPEGEncodableFormat(int i) {
        return this.getFormat(this.JPEGformats, i);
    }

    public List<ImageFormat> getRGBEncodableFormats() {
        return new Vector<ImageFormat>(this.RGBformats);
    }

    public ImageFormat getRGBEncodableFormat(String n) {
        return this.getFormat(this.RGBformats, n);
    }

    public ImageFormat getRGBEncodableFormat(int i) {
        return this.getFormat(this.RGBformats, i);
    }

    public List<ImageFormat> getBGREncodableFormats() {
        return new Vector<ImageFormat>(this.BGRformats);
    }

    public ImageFormat getBGREncodableFormat(String n) {
        return this.getFormat(this.BGRformats, n);
    }

    public ImageFormat getBGREncodableFormat(int i) {
        return this.getFormat(this.BGRformats, i);
    }

    public List<ImageFormat> getYUVEncodableFormats() {
        return new Vector<ImageFormat>(this.YUV420formats);
    }

    public ImageFormat getYUVEncodableFormat(String n) {
        return this.getFormat(this.YUV420formats, n);
    }

    public ImageFormat getYUVEncodableFormat(int i) {
        return this.getFormat(this.YUV420formats, i);
    }

    public List<ImageFormat> getYVUEncodableFormats() {
        return new Vector<ImageFormat>(this.YVU420formats);
    }

    public ImageFormat getYVUEncodableFormat(String n) {
        return this.getFormat(this.YVU420formats, n);
    }

    public ImageFormat getYVUEncodableFormat(int i) {
        return this.getFormat(this.YVU420formats, i);
    }

    static {
        try {
            System.loadLibrary("v4l4j");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Cant load v4l4j JNI library");
            throw e;
        }
    }
}

