/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.JPEGVideoFrame;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.util.concurrent.ThreadFactory;

public class JPEGFrameGrabber
extends AbstractGrabber {
    private int quality;

    JPEGFrameGrabber(DeviceInfo di, long o, int w, int h, int ch, int std, int q, Tuner t, ImageFormat imf, ThreadFactory factory) throws V4L4JException {
        super(di, o, w, h, ch, std, t, imf, 1, factory);
        this.quality = q;
    }

    @Override
    void init() throws V4L4JException {
        try {
            super.init();
            this.setJPGQuality(this.quality);
        }
        catch (ImageFormatException ife) {
            if (this.format == -1) {
                String msg = "v4l4j was unable to find image format supported bythe \nvideo device and that can be encoded in JPEG.\nPlease let the author know about this, so that support\nfor this video device can be improved. See \nREADME file on how to submit v4l4j reports.";
                System.out.println(msg);
                ife = new ImageFormatException(msg);
            }
            throw ife;
        }
    }

    public void setJPGQuality(int q) {
        this.state.checkReleased();
        if (q < 0) {
            q = 0;
        }
        if (q > 100) {
            q = 100;
        }
        this.setQuality(this.object, q);
        this.quality = q;
    }

    public int getJPGQuality() {
        this.state.checkReleased();
        return this.quality;
    }

    @Override
    public ImageFormat getImageFormat() {
        this.state.checkReleased();
        return this.dInfo.getFormatList().getNativeFormat(this.format);
    }

    @Override
    protected void createBuffers(int bufferSize) {
        int numberOfBuffers = this.nbV4LBuffers;
        while (numberOfBuffers-- > 0) {
            this.videoFrames.add(new JPEGVideoFrame(this, bufferSize));
        }
    }
}

