/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.BGRFrameGrabber;
import au.edu.jcu.v4l4j.Control;
import au.edu.jcu.v4l4j.ControlList;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.ImageFormatList;
import au.edu.jcu.v4l4j.InputInfo;
import au.edu.jcu.v4l4j.JPEGFrameGrabber;
import au.edu.jcu.v4l4j.RGBFrameGrabber;
import au.edu.jcu.v4l4j.RawFrameGrabber;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.TunerList;
import au.edu.jcu.v4l4j.YUVFrameGrabber;
import au.edu.jcu.v4l4j.YVUFrameGrabber;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.NoTunerException;
import au.edu.jcu.v4l4j.exceptions.ReleaseException;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.io.File;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class VideoDevice {
    private AbstractGrabber fg;
    private DeviceInfo deviceInfo;
    private ControlList controls;
    private TunerList tuners;
    private String deviceFile;
    private State state;
    private boolean supportJPEG;
    private boolean supportRGB24;
    private boolean supportBGR24;
    private boolean supportYUV420;
    private boolean supportYVU420;
    private long v4l4jObject;
    private ThreadFactory threadFactory;

    private native long doInit(String var1) throws V4L4JException;

    private native void doRelease(long var1);

    private native Control[] doGetControlList(long var1);

    private native void doReleaseControlList(long var1);

    private native void doGetTunerActions(long var1);

    private native void doReleaseTunerActions(long var1);

    public VideoDevice(String dev) throws V4L4JException {
        if (dev == null) {
            throw new NullPointerException("the device file cannot be null");
        }
        if (!new File(dev).canRead()) {
            throw new V4L4JException("The device file is not readable");
        }
        this.threadFactory = Executors.defaultThreadFactory();
        this.state = new State();
        this.deviceFile = dev;
        this.v4l4jObject = this.doInit(this.deviceFile);
        try {
            this.initDeviceInfo();
        }
        catch (V4L4JException e) {
            this.deviceInfo = null;
            this.supportJPEG = false;
            this.supportRGB24 = false;
            this.supportBGR24 = false;
            this.supportYUV420 = false;
            this.supportYVU420 = false;
        }
    }

    private void initDeviceInfo() throws V4L4JException {
        this.deviceInfo = new DeviceInfo(this.v4l4jObject, this.deviceFile);
        ImageFormatList l = this.deviceInfo.getFormatList();
        this.supportJPEG = l.getJPEGEncodableFormats().size() != 0;
        this.supportRGB24 = l.getRGBEncodableFormats().size() != 0;
        this.supportBGR24 = l.getBGREncodableFormats().size() != 0;
        this.supportYUV420 = l.getYUVEncodableFormats().size() != 0;
        this.supportYVU420 = l.getYVUEncodableFormats().size() != 0;
        Vector<Tuner> v = new Vector<Tuner>();
        this.doGetTunerActions(this.v4l4jObject);
        for (InputInfo i : this.deviceInfo.getInputs()) {
            try {
                v.add(new Tuner(this.v4l4jObject, i.getTunerInfo()));
            }
            catch (NoTunerException e) {}
        }
        if (v.size() != 0) {
            this.tuners = new TunerList(v);
        }
    }

    public void release() {
        this.release(true);
    }

    public void release(boolean wait) {
        this.state.release(wait);
        if (this.tuners != null) {
            this.tuners.release();
        }
        this.doReleaseTunerActions(this.v4l4jObject);
        if (this.deviceInfo != null) {
            this.deviceInfo.release();
        }
        this.doRelease(this.v4l4jObject);
        this.state.commit();
    }

    public DeviceInfo getDeviceInfo() throws V4L4JException {
        if (this.deviceInfo != null) {
            return this.deviceInfo;
        }
        throw new V4L4JException("Error getting information about device");
    }

    public String getDevicefile() {
        return this.deviceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlList getControlList() {
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.controls == null) {
                this.state.get();
                this.controls = new ControlList(this.doGetControlList(this.v4l4jObject));
            }
            return this.controls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseControlList() {
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.controls != null) {
                this.controls.release();
                this.doReleaseControlList(this.v4l4jObject);
                this.controls = null;
                this.state.put();
            }
        }
    }

    public boolean supportJPEGConversion() {
        return this.supportJPEG;
    }

    public boolean supportRGBConversion() {
        return this.supportRGB24;
    }

    public boolean supportBGRConversion() {
        return this.supportBGR24;
    }

    public boolean supportYUVConversion() {
        return this.supportYUV420;
    }

    public boolean supportYVUConversion() {
        return this.supportYVU420;
    }

    public JPEGFrameGrabber getJPEGFrameGrabber(int w, int h, int input, int std, int q, ImageFormat imf) throws V4L4JException {
        if (!this.supportJPEG || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support JPEG-encoding of its frames.");
        }
        if (imf != null) {
            if (!this.deviceInfo.getFormatList().getJPEGEncodableFormats().contains(imf)) {
                throw new ImageFormatException("The image format " + imf.getName() + " cannot be JPEG " + "encoded.");
            }
        } else {
            imf = this.deviceInfo.getFormatList().getJPEGEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new JPEGFrameGrabber(this.deviceInfo, this.v4l4jObject, w, h, input, std, q, this.findTuner(input), imf, this.threadFactory);
                try {
                    this.fg.init();
                }
                catch (V4L4JException ve) {
                    this.fg = null;
                    this.state.put();
                    throw ve;
                }
                catch (StateException se) {
                    this.fg = null;
                    this.state.put();
                    throw se;
                }
                catch (Throwable t) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", t);
                }
                return (JPEGFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(JPEGFrameGrabber.class)) {
                return (JPEGFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public JPEGFrameGrabber getJPEGFrameGrabber(int w, int h, int input, int std, int q) throws V4L4JException {
        return this.getJPEGFrameGrabber(w, h, input, std, q, null);
    }

    public RGBFrameGrabber getRGBFrameGrabber(int w, int h, int input, int std, ImageFormat imf) throws V4L4JException {
        if (!this.supportRGB24 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support RGB-encoding of its frames.");
        }
        if (imf != null) {
            if (!this.deviceInfo.getFormatList().getRGBEncodableFormats().contains(imf)) {
                throw new ImageFormatException("The image format " + imf.getName() + " cannot be converted to RGB24");
            }
        } else {
            imf = this.deviceInfo.getFormatList().getRGBEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new RGBFrameGrabber(this.deviceInfo, this.v4l4jObject, w, h, input, std, this.findTuner(input), imf, this.threadFactory);
                try {
                    this.fg.init();
                }
                catch (V4L4JException ve) {
                    this.fg = null;
                    this.state.put();
                    throw ve;
                }
                catch (StateException se) {
                    this.fg = null;
                    this.state.put();
                    throw se;
                }
                catch (Throwable t) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", t);
                }
                return (RGBFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(RGBFrameGrabber.class)) {
                return (RGBFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public RGBFrameGrabber getRGBFrameGrabber(int w, int h, int input, int std) throws V4L4JException {
        return this.getRGBFrameGrabber(w, h, input, std, null);
    }

    public BGRFrameGrabber getBGRFrameGrabber(int w, int h, int input, int std, ImageFormat imf) throws V4L4JException {
        if (!this.supportBGR24 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support BGR-encoding of its frames.");
        }
        if (imf != null) {
            if (!this.deviceInfo.getFormatList().getBGREncodableFormats().contains(imf)) {
                throw new ImageFormatException("The image format " + imf.getName() + " cannot be converted to BGR24");
            }
        } else {
            imf = this.deviceInfo.getFormatList().getBGREncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new BGRFrameGrabber(this.deviceInfo, this.v4l4jObject, w, h, input, std, this.findTuner(input), imf, this.threadFactory);
                try {
                    this.fg.init();
                }
                catch (V4L4JException ve) {
                    this.fg = null;
                    this.state.put();
                    throw ve;
                }
                catch (StateException se) {
                    this.fg = null;
                    this.state.put();
                    throw se;
                }
                catch (Throwable t) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", t);
                }
                return (BGRFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(BGRFrameGrabber.class)) {
                return (BGRFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public BGRFrameGrabber getBGRFrameGrabber(int w, int h, int input, int std) throws V4L4JException {
        return this.getBGRFrameGrabber(w, h, input, std, null);
    }

    public YUVFrameGrabber getYUVFrameGrabber(int w, int h, int input, int std, ImageFormat imf) throws V4L4JException {
        if (!this.supportYUV420 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support YUV-encoding of its frames.");
        }
        if (imf != null) {
            if (!this.deviceInfo.getFormatList().getYUVEncodableFormats().contains(imf)) {
                throw new ImageFormatException("The image format " + imf.getName() + " cannot be converted to YUV420");
            }
        } else {
            imf = this.deviceInfo.getFormatList().getYUVEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new YUVFrameGrabber(this.deviceInfo, this.v4l4jObject, w, h, input, std, this.findTuner(input), imf, this.threadFactory);
                try {
                    this.fg.init();
                }
                catch (V4L4JException ve) {
                    this.fg = null;
                    this.state.put();
                    throw ve;
                }
                catch (StateException se) {
                    this.fg = null;
                    this.state.put();
                    throw se;
                }
                catch (Throwable t) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", t);
                }
                return (YUVFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(YUVFrameGrabber.class)) {
                return (YUVFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public YUVFrameGrabber getYUVFrameGrabber(int w, int h, int input, int std) throws V4L4JException {
        return this.getYUVFrameGrabber(w, h, input, std, null);
    }

    public YVUFrameGrabber getYVUFrameGrabber(int w, int h, int input, int std, ImageFormat imf) throws V4L4JException {
        if (!this.supportYVU420 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support YVU-encoding of its frames.");
        }
        if (imf != null) {
            if (!this.deviceInfo.getFormatList().getYVUEncodableFormats().contains(imf)) {
                throw new ImageFormatException("The image format " + imf.getName() + " cannot be converted to YVU420");
            }
        } else {
            imf = this.deviceInfo.getFormatList().getYVUEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new YVUFrameGrabber(this.deviceInfo, this.v4l4jObject, w, h, input, std, this.findTuner(input), imf, this.threadFactory);
                try {
                    this.fg.init();
                }
                catch (V4L4JException ve) {
                    this.fg = null;
                    this.state.put();
                    throw ve;
                }
                catch (StateException se) {
                    this.fg = null;
                    this.state.put();
                    throw se;
                }
                catch (Throwable t) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", t);
                }
                return (YVUFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(YUVFrameGrabber.class)) {
                return (YVUFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public YVUFrameGrabber getYVUFrameGrabber(int w, int h, int input, int std) throws V4L4JException {
        return this.getYVUFrameGrabber(w, h, input, std, null);
    }

    public RawFrameGrabber getRawFrameGrabber(int w, int h, int input, int std, ImageFormat format) throws V4L4JException {
        if (format == null) {
            throw new ImageFormatException("The image format can not be null");
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new RawFrameGrabber(this.deviceInfo, this.v4l4jObject, w, h, input, std, this.findTuner(input), format, this.threadFactory);
                try {
                    this.fg.init();
                }
                catch (V4L4JException ve) {
                    this.fg = null;
                    this.state.put();
                    throw ve;
                }
                catch (StateException se) {
                    this.fg = null;
                    this.state.put();
                    throw se;
                }
                catch (Throwable t) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", t);
                }
                return (RawFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(RawFrameGrabber.class)) {
                return (RawFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("Another FrameGrabber object already exists");
        }
    }

    public RawFrameGrabber getRawFrameGrabber(int w, int h, int input, int std) throws V4L4JException {
        if (this.deviceInfo == null) {
            throw new ImageFormatException("No DeviceInfo could be obtained. The device is probably used by another application");
        }
        return this.getRawFrameGrabber(w, h, input, std, this.deviceInfo.getFormatList().getNativeFormats().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFrameGrabber() {
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg != null) {
                try {
                    this.fg.release();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new StateException("Cant release resources used by framegrabber", t);
                }
                this.fg = null;
                this.state.put();
            }
        }
    }

    public TunerList getTunerList() throws NoTunerException {
        if (this.tuners == null) {
            throw new NoTunerException("This video device does not have any tuners");
        }
        return this.tuners;
    }

    private Tuner findTuner(int input) {
        if (this.deviceInfo != null) {
            for (InputInfo i : this.deviceInfo.getInputs()) {
                if (i.getIndex() != input || !i.hasTuner()) continue;
                try {
                    return this.tuners.getTuner(i.getTunerInfo().getIndex());
                }
                catch (NoTunerException e) {
                }
            }
        }
        return null;
    }

    public synchronized void setThreadFactory(ThreadFactory factory) {
        if (factory == null) {
            factory = Executors.defaultThreadFactory();
        }
        this.threadFactory = factory;
    }

    private static class State {
        private int state = this.INIT;
        private int temp = this.INIT;
        private int users = 0;
        private int INIT = 1;
        private int RELEASED = 2;

        public synchronized void get() {
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                ++this.users;
            } else {
                throw new StateException("This VideoDevice has not been initialised or is about to be removed, and can not be used");
            }
        }

        public synchronized void put() {
            if (this.state == this.INIT) {
                if (--this.users == 0 && this.temp == this.RELEASED) {
                    this.notify();
                }
            } else {
                throw new StateException("This VideoDevice has not been initialised and can not be used");
            }
        }

        public synchronized void release() {
            this.release(true);
        }

        public synchronized void release(boolean wait) {
            int t = this.temp;
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                this.temp = this.RELEASED;
                while (this.users != 0) {
                    try {
                        if (wait) {
                            this.wait();
                            continue;
                        }
                        this.temp = t;
                        throw new ReleaseException("Still in use");
                    }
                    catch (InterruptedException e) {
                        this.temp = t;
                        System.err.println("Interrupted while waiting for VideoDevice users to complete");
                        e.printStackTrace();
                        throw new StateException("There are remaining users of this VideoDevice and it can not be released");
                    }
                }
                return;
            }
            throw new StateException("This VideoDevice has not been initialised and can not be used");
        }

        public synchronized void commit() {
            this.state = this.temp;
        }
    }
}

