/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.v4l4j;

import com.github.sarxos.v4l4j.NativeUtils;
import java.io.File;
import java.io.IOException;

public class V4L4J {
    private static String getArch() {
        String arch = System.getProperty("os.arch");
        String dataModel = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        if (V4L4J.isArm()) {
            return "arm" + V4L4J.getFloat();
        }
        String bits = "32".equals(dataModel) ? "32" : ("64".equals(dataModel) ? "64" : (arch.contains("64") || arch.equalsIgnoreCase("sparcv9") ? "64" : "32"));
        return bits;
    }

    private static boolean isArm() {
        return System.getProperty("os.arch").equals("arm");
    }

    private static String getFloat() {
        if (V4L4J.isArm()) {
            return new File("/lib/arm-linux-gnueabihf").isDirectory() ? "hf" : "el";
        }
        return "";
    }

    public static final void init() {
        String arch = V4L4J.getArch();
        try {
            NativeUtils.loadLibraryFromJar("/META-INF/native/linux-" + arch, new String[]{"video", "v4l4j"});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

