/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.ipcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoveryService;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.ds.ipcam.IpCamAuth;
import com.github.sarxos.webcam.ds.ipcam.IpCamDevice;
import com.github.sarxos.webcam.ds.ipcam.IpCamMode;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IpCamDeviceRegistry {
    private static final List<IpCamDevice> DEVICES = new ArrayList<IpCamDevice>();

    public static IpCamDevice register(IpCamDevice ipcam) {
        for (WebcamDevice webcamDevice : DEVICES) {
            String name = ipcam.getName();
            if (!webcamDevice.getName().equals(name)) continue;
            throw new WebcamException(String.format("Webcam with name '%s' is already registered", name));
        }
        DEVICES.add(ipcam);
        IpCamDeviceRegistry.rescan();
        return ipcam;
    }

    public static IpCamDevice register(String name, String url, IpCamMode mode) throws MalformedURLException {
        return IpCamDeviceRegistry.register(new IpCamDevice(name, url, mode));
    }

    public static IpCamDevice register(String name, URL url, IpCamMode mode) {
        return IpCamDeviceRegistry.register(new IpCamDevice(name, url, mode));
    }

    public static IpCamDevice register(String name, String url, IpCamMode mode, IpCamAuth auth) throws MalformedURLException {
        return IpCamDeviceRegistry.register(new IpCamDevice(name, url, mode, auth));
    }

    public static IpCamDevice register(String name, URL url, IpCamMode mode, IpCamAuth auth) {
        return IpCamDeviceRegistry.register(new IpCamDevice(name, url, mode, auth));
    }

    public static boolean isRegistered(IpCamDevice ipcam) {
        if (ipcam == null) {
            throw new IllegalArgumentException("IP camera device cannot be null");
        }
        Iterator<IpCamDevice> di = DEVICES.iterator();
        while (di.hasNext()) {
            if (!di.next().getName().equals(ipcam.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegistered(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Device name cannot be null");
        }
        Iterator<IpCamDevice> di = DEVICES.iterator();
        while (di.hasNext()) {
            if (!di.next().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegistered(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Camera device URL cannot be null");
        }
        try {
            return IpCamDeviceRegistry.isRegistered(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new WebcamException((Throwable)e);
        }
    }

    public static boolean isRegistered(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Camera device URI cannot be null");
        }
        for (IpCamDevice d : DEVICES) {
            try {
                if (!d.getURL().toURI().equals(uri)) continue;
                return true;
            }
            catch (URISyntaxException e) {
                throw new WebcamException((Throwable)e);
            }
        }
        return false;
    }

    public static boolean unregister(IpCamDevice ipcam) {
        try {
            boolean bl = DEVICES.remove(ipcam);
            return bl;
        }
        finally {
            IpCamDeviceRegistry.rescan();
        }
    }

    private static void rescan() {
        WebcamDiscoveryService discovery = Webcam.getDiscoveryServiceRef();
        if (discovery != null) {
            discovery.scan();
        }
    }

    public static boolean unregister(String name) {
        Iterator<IpCamDevice> di = DEVICES.iterator();
        while (di.hasNext()) {
            IpCamDevice d = di.next();
            if (!d.getName().equals(name)) continue;
            di.remove();
            IpCamDeviceRegistry.rescan();
            return true;
        }
        return false;
    }

    public static List<IpCamDevice> getIpCameras() {
        return Collections.unmodifiableList(DEVICES);
    }

    public static void unregisterAll() {
        DEVICES.clear();
        IpCamDeviceRegistry.rescan();
    }
}

