/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.ipcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoverySupport;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.ds.ipcam.IpCamDevice;
import com.github.sarxos.webcam.ds.ipcam.IpCamDeviceRegistry;
import com.github.sarxos.webcam.ds.ipcam.IpCamStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpCamDriver
implements WebcamDriver,
WebcamDiscoverySupport {
    private static final Logger LOG = LoggerFactory.getLogger(IpCamDriver.class);
    private static final ThreadFactory THREAD_FACTORY = new DeviceCheckThreadFactory();
    private volatile long scanInterval = 10000L;
    private volatile long scanTimeout = 10000L;
    private volatile boolean scanning = false;
    private final ExecutorService executor = Executors.newCachedThreadPool(THREAD_FACTORY);

    public IpCamDriver() {
        this(null, false);
    }

    public IpCamDriver(boolean scanning) {
        this(null, scanning);
    }

    public IpCamDriver(IpCamStorage storage) {
        this(storage, false);
    }

    public IpCamDriver(IpCamStorage storage, boolean scanning) {
        if (storage != null) {
            storage.open();
        }
        this.scanning = scanning;
    }

    public List<WebcamDevice> getDevices() {
        if (!this.isScanPossible()) {
            return Collections.unmodifiableList(IpCamDeviceRegistry.getIpCameras());
        }
        List<IpCamDevice> devices = IpCamDeviceRegistry.getIpCameras();
        CountDownLatch latch = new CountDownLatch(devices.size());
        ArrayList<Future<IpCamDevice>> futures = new ArrayList<Future<IpCamDevice>>(devices.size());
        for (IpCamDevice ipCamDevice : devices) {
            futures.add(this.executor.submit(new DeviceOnlineCheck(ipCamDevice, latch)));
        }
        try {
            if (!latch.await(this.scanTimeout, TimeUnit.MILLISECONDS)) {
                for (Future future : futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
        }
        catch (InterruptedException e1) {
            return null;
        }
        ArrayList<IpCamDevice> online = new ArrayList<IpCamDevice>(devices.size());
        for (Future future : futures) {
            IpCamDevice device = null;
            try {
                device = (IpCamDevice)future.get();
                if (device == null) continue;
                online.add(device);
            }
            catch (InterruptedException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            catch (CancellationException e) {
            }
            catch (ExecutionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return Collections.unmodifiableList(online);
    }

    public void register(IpCamDevice device) {
        IpCamDeviceRegistry.register(device);
    }

    public void unregister(IpCamDevice device) {
        IpCamDeviceRegistry.unregister(device);
    }

    public boolean isThreadSafe() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public long getScanInterval() {
        return this.scanInterval;
    }

    public void setScanInterval(long scanInterval) {
        if (scanInterval <= 0L) {
            throw new IllegalArgumentException("Scan interval for IP camera cannot be negative");
        }
        this.scanInterval = scanInterval;
    }

    public boolean isScanPossible() {
        return this.scanning;
    }

    public void setScanPossible(boolean scanning) {
        this.scanning = scanning;
    }

    public long getScanTimeout() {
        return this.scanTimeout;
    }

    public void setScanTimeout(long scanTimeout) {
        if (scanTimeout < 1000L) {
            scanTimeout = 1000L;
        }
        this.scanTimeout = scanTimeout;
    }

    private static class DeviceOnlineCheck
    implements Callable<IpCamDevice> {
        private final IpCamDevice device;
        private final CountDownLatch latch;

        public DeviceOnlineCheck(IpCamDevice device, CountDownLatch latch) {
            this.device = device;
            this.latch = latch;
        }

        @Override
        public IpCamDevice call() throws Exception {
            try {
                IpCamDevice ipCamDevice = this.device.isOnline() ? this.device : null;
                return ipCamDevice;
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    private static class DeviceCheckThreadFactory
    implements ThreadFactory {
        private AtomicInteger number = new AtomicInteger();

        private DeviceCheckThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "online-check-" + this.number.incrementAndGet());
            t.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)WebcamExceptionHandler.getInstance());
            t.setDaemon(true);
            return t;
        }
    }
}

