/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.ipcam.impl;

import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.ds.ipcam.IpCamAuth;
import com.github.sarxos.webcam.ds.ipcam.IpCamMode;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class IpCamDescriptor {
    @XmlAttribute
    private String name = null;
    @XmlAttribute(name="url")
    private String urlString = null;
    private transient URL url = null;
    @XmlAttribute(name="mode")
    private IpCamMode mode = IpCamMode.PULL;
    @XmlElement(name="auth")
    private AuthParams authParams = null;
    private transient IpCamAuth auth = null;

    public String getName() {
        return this.name;
    }

    public URL getURL() {
        if (this.urlString != null && this.url == null) {
            try {
                this.url = new URL(this.urlString);
            }
            catch (MalformedURLException e) {
                throw new WebcamException((Throwable)e);
            }
        }
        return this.url;
    }

    public IpCamMode getMode() {
        return this.mode;
    }

    public IpCamAuth getAuth() {
        if (this.authParams != null && this.auth == null) {
            this.auth = new IpCamAuth(this.authParams.getUser(), this.authParams.getPassword());
        }
        return this.auth;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    protected static class AuthParams {
        @XmlAttribute
        private String user = null;
        @XmlAttribute
        private String password = null;

        protected AuthParams() {
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

