/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.ipcam.impl;

import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpCamHttpClient
extends DefaultHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(IpCamHttpClient.class);
    public static final String PROXY_HOST_KEY = "http.proxyHost";
    public static final String PROXY_PORT_KEY = "http.proxyPort";
    private HttpHost proxy = null;

    public IpCamHttpClient() {
        super((ClientConnectionManager)new PoolingClientConnectionManager());
        String proxyHost = System.getProperty(PROXY_HOST_KEY);
        String proxyPort = System.getProperty(PROXY_PORT_KEY);
        if (proxyHost != null && proxyPort != null) {
            LOG.debug("Setting proxy '{}:{}'", (Object)proxyHost, (Object)proxyPort);
            this.proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort), "http");
            this.setProxy(this.proxy);
        }
    }

    public void setProxy(HttpHost proxy) {
        this.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }
}

