/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.ipcam.impl;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpCamMJPEGStream
extends DataInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(IpCamMJPEGStream.class);
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private final byte[] EOI_MARKER = new byte[]{-1, -39};
    private final String CONTENT_LENGTH = "Content-Length";
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 100100;
    private boolean open = true;

    public IpCamMJPEGStream(InputStream in) {
        super(new BufferedInputStream(in, 100100));
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        int s = 0;
        for (int i = 0; i < 100100; ++i) {
            byte c = (byte)in.readUnsignedByte();
            if (c == sequence[s]) {
                if (++s != sequence.length) continue;
                return i + 1;
            }
            s = 0;
        }
        return -1;
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        int end = this.getEndOfSeqeunce(in, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, NumberFormatException {
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (!line.startsWith("Content-Length") || (parts = line.split(":")).length != 2) continue;
            return Integer.parseInt(parts[1].trim());
        }
        return 0;
    }

    public BufferedImage readFrame() throws IOException {
        if (!this.open) {
            return null;
        }
        byte[] header = null;
        byte[] frame = null;
        this.mark(100100);
        int n = this.getStartOfSequence(this, this.SOI_MARKER);
        this.reset();
        header = new byte[n];
        this.readFully(header);
        int length = -1;
        try {
            length = this.parseContentLength(header);
        }
        catch (NumberFormatException e) {
            length = this.getEndOfSeqeunce(this, this.EOI_MARKER);
        }
        if (length == 0) {
            LOG.error("Invalid MJPEG stream, EOI (0xFF,0xD9) not found!");
        }
        this.reset();
        frame = new byte[length];
        this.skipBytes(n);
        this.readFully(frame);
        try {
            return ImageIO.read(new ByteArrayInputStream(frame));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        super.close();
    }

    public boolean isClosed() {
        return !this.open;
    }
}

