/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamProcessor;

public abstract class WebcamTask {
    private boolean sync = true;
    private WebcamProcessor processor = null;
    private WebcamDevice device = null;
    private WebcamException exception = null;

    public WebcamTask(WebcamDriver driver, WebcamDevice device) {
        if (driver == null) {
            throw new IllegalArgumentException("Webcam driver argument cannot be null");
        }
        this.sync = !driver.isThreadSafe();
        this.device = device;
        this.processor = WebcamProcessor.getInstance();
    }

    public WebcamDevice getDevice() {
        return this.device;
    }

    public void process() {
        if (this.sync) {
            if (this.processor == null) {
                throw new RuntimeException("Driver should be synchronized, but processor is null");
            }
            this.processor.process(this);
        } else {
            this.handle();
        }
    }

    public WebcamException getException() {
        return this.exception;
    }

    public void setException(WebcamException exception) {
        this.exception = exception;
    }

    protected abstract void handle();
}

