/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamLogConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamLogConfigurator.class);

    public static void configure(InputStream is) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        context.reset();
        try {
            configurator.doConfigure(is);
        }
        catch (JoranException e) {
            LOG.error("Joran configuration exception", (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            WebcamLogConfigurator.configure(fis);
        }
        catch (FileNotFoundException e) {
            LOG.error("File not found " + file, (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error("Cannot close file " + file, (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    public static void configure(String file) {
        WebcamLogConfigurator.configure(new File(file));
    }
}

