/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;

public class FileUtils {
    protected static Integer MAX_EXTENSION_LENGTH = 6;
    protected static String[] IGNORED_EXTENSION_SUFFIXES = new String[]{"7z", "bz2", "gz"};

    public static File replaceExtension(File file, String newExt) {
        return new File(FileUtils.replaceExtension(file.getAbsolutePath(), newExt));
    }

    public static String replaceExtension(String file, String newExt) {
        String result = file;
        int index = file.lastIndexOf(46);
        if (index > -1) {
            result = newExt.length() > 0 ? file.substring(0, index) + newExt : file.substring(0, index);
        }
        return result;
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(String filename) {
        String[] result = FileUtils.getExtensions(filename);
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public static String[] getExtensions(File file) {
        return FileUtils.getExtensions(file.getAbsolutePath());
    }

    public static String[] getExtensions(String filename) {
        if (filename.indexOf(46) == -1) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String shortened = FileUtils.removeIgnoredExtensionSuffixes(filename);
        int pos = filename.lastIndexOf(46, shortened.length() - 1);
        result.add(filename.substring(pos + 1));
        int posNext = filename.lastIndexOf(46, pos - 1);
        if (posNext > -1 && pos - posNext <= MAX_EXTENSION_LENGTH) {
            result.add(filename.substring(posNext + 1));
        }
        return result.toArray(new String[result.size()]);
    }

    public static String removeIgnoredExtensionSuffixes(String filename) {
        String result = filename;
        for (String suffix : IGNORED_EXTENSION_SUFFIXES) {
            if (!result.endsWith("." + suffix)) continue;
            result = result.substring(0, result.length() - suffix.length() - 1);
        }
        return result;
    }

    public static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean delete(File file) {
        File[] files;
        boolean result = true;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                if (f.getName().equals(".") || f.getName().equals("..") || (result = FileUtils.delete(f))) continue;
                return false;
            }
        }
        result = file.delete();
        return result;
    }

    public static boolean copyOrMove(File sourceLocation, File targetLocation, boolean move, boolean atomic) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdir()) {
                return false;
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                if (FileUtils.copyOrMove(new File(sourceLocation.getAbsoluteFile(), children[i]), new File(targetLocation.getAbsoluteFile(), children[i]), move, atomic)) continue;
                return false;
            }
            if (move) {
                return sourceLocation.delete();
            }
            return true;
        }
        Path source = FileSystems.getDefault().getPath(sourceLocation.getAbsolutePath(), new String[0]);
        Path target = targetLocation.isDirectory() ? FileSystems.getDefault().getPath(targetLocation.getAbsolutePath() + File.separator + sourceLocation.getName(), new String[0]) : FileSystems.getDefault().getPath(targetLocation.getAbsolutePath(), new String[0]);
        if (move) {
            if (atomic) {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            } else {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        return true;
    }

    public static String writeToFileMsg(String filename, Object obj, boolean append, String encoding) {
        String result = null;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("" + obj);
        OpenOption[] options = append ? new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE} : new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        try {
            if (encoding == null) {
                Files.write(new File(filename).toPath(), lines, options);
            } else {
                Files.write(new File(filename).toPath(), lines, Charset.forName(encoding), options);
            }
        }
        catch (Exception e) {
            result = "Failed to write to '" + filename + "'\n" + e;
        }
        return result;
    }
}

