/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.io.File;
import nz.ac.waikato.cms.gui.core.AbstractChooserPanel;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;

public class DirectoryChooserPanel
extends AbstractChooserPanel<File> {
    private static final long serialVersionUID = 6235369491956122980L;
    protected BaseDirectoryChooser m_DirectoryChooser;

    public DirectoryChooserPanel() {
        this("");
    }

    public DirectoryChooserPanel(String path) {
        this(new File(path));
    }

    public DirectoryChooserPanel(File path) {
        this.setCurrent(path);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DirectoryChooser = new BaseDirectoryChooser();
    }

    @Override
    protected File doChoose() {
        this.m_DirectoryChooser.setSelectedFile((File)this.getCurrent());
        if (this.m_DirectoryChooser.showOpenDialog(this.m_Self) == 0) {
            return this.m_DirectoryChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    protected String toString(File value) {
        String result = value.getAbsolutePath();
        if (result.equals(System.getProperty("user.dir"))) {
            result = ".";
        }
        return result;
    }

    @Override
    protected File fromString(String value) {
        try {
            return new File(value).getCanonicalFile();
        }
        catch (Exception e) {
            return new File(value);
        }
    }

    public void setCurrentDirectory(String value) {
        this.setCurrent(this.fromString(value));
    }

    public String getCurrentDirectory() {
        return ((File)this.getCurrent()).getAbsolutePath();
    }

    @Override
    public boolean setCurrent(File value) {
        boolean result = super.setCurrent(value);
        this.m_DirectoryChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        return result;
    }

    public String getChooserType() {
        return "Local";
    }
}

