/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import com.googlecode.jfilechooserbookmarks.event.RemoveItemsListener;
import com.googlecode.jfilechooserbookmarks.gui.BaseList;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nz.ac.waikato.cms.gui.core.BasePanel;
import nz.ac.waikato.cms.gui.core.DetachablePanel;
import nz.ac.waikato.cms.gui.core.GUIHelper;
import nz.ac.waikato.cms.gui.core.MouseUtils;

public class MultiPagePane
extends BasePanel {
    private static final long serialVersionUID = -2108092957035381345L;
    protected JSplitPane m_SplitPane;
    protected BasePanel m_LeftPanel;
    protected BaseList m_PageList;
    protected DefaultListModel<PageContainer> m_PageListModel;
    protected BasePanel m_PanelListButtons;
    protected JideButton m_ButtonUp;
    protected JideButton m_ButtonDown;
    protected JideButton m_ButtonRemove;
    protected JideButton m_ButtonRemoveAll;
    protected JideButton m_ButtonUndo;
    protected JideSplitButton m_ButtonAction;
    protected BasePanel m_PanelContent;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected boolean m_IgnoreUpdates;
    protected PageCloseApprover m_PageCloseApprover;
    protected PopupCustomizer m_PopupCustomizer;
    protected ToolTipCustomizer m_ToolTipCustomizer;
    protected boolean m_ReadOnly;
    protected int m_MaxPageCloseUndo;
    protected transient List<PageUndo> m_PageUndoList;
    protected boolean m_SkipPageUndo;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PageListModel = new DefaultListModel();
        this.m_ChangeListeners = new HashSet();
        this.m_IgnoreUpdates = false;
        this.m_PageCloseApprover = null;
        this.m_PopupCustomizer = null;
        this.m_ToolTipCustomizer = null;
        this.m_ReadOnly = false;
        this.m_MaxPageCloseUndo = 0;
        this.m_PageUndoList = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new JSplitPane(1);
        this.m_SplitPane.setDividerLocation(200);
        this.m_SplitPane.setResizeWeight(0.0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_LeftPanel = new BasePanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent(this.m_LeftPanel);
        this.m_PageList = new BaseList(this.m_PageListModel);
        this.m_PageList.setSelectionMode(2);
        this.m_PageList.addListSelectionListener(e -> this.update());
        this.m_PageList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!MultiPagePane.this.processListKey(e)) {
                    super.keyPressed(e);
                }
            }
        });
        this.m_PageList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = MultiPagePane.this.m_PageList.locationToIndex(e.getPoint());
                MultiPagePane.this.m_PageList.setToolTipText(MultiPagePane.this.generateToolTip(index));
            }
        });
        this.m_PageList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    MultiPagePane.this.showPopup(e);
                    e.consume();
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_LeftPanel.add((Component)new JScrollPane((Component)this.m_PageList), "Center");
        this.m_PanelListButtons = new BasePanel(new FlowLayout(0));
        this.m_LeftPanel.add((Component)this.m_PanelListButtons, "South");
        this.m_ButtonUp = new JideButton((Icon)GUIHelper.getIcon("arrow_up.gif"));
        this.m_ButtonUp.setButtonStyle(1);
        this.m_ButtonUp.setFont(this.getFont().deriveFont(0));
        this.m_ButtonUp.setToolTipText("Moves up selected");
        this.m_ButtonUp.addActionListener(e -> this.moveUp());
        this.m_PanelListButtons.add((Component)this.m_ButtonUp);
        this.m_ButtonDown = new JideButton((Icon)GUIHelper.getIcon("arrow_down.gif"));
        this.m_ButtonDown.setButtonStyle(1);
        this.m_ButtonDown.setFont(this.getFont().deriveFont(0));
        this.m_ButtonDown.setToolTipText("Moves down selected");
        this.m_ButtonDown.addActionListener(e -> this.moveDown());
        this.m_PanelListButtons.add((Component)this.m_ButtonDown);
        this.m_ButtonRemove = new JideButton((Icon)GUIHelper.getIcon("delete.gif"));
        this.m_ButtonRemove.setButtonStyle(1);
        this.m_ButtonRemove.setFont(this.getFont().deriveFont(0));
        this.m_ButtonRemove.setToolTipText("Removes currently selected");
        this.m_ButtonRemove.addActionListener(e -> this.checkedRemoveSelectedPages());
        this.m_PanelListButtons.add((Component)this.m_ButtonRemove);
        this.m_ButtonRemoveAll = new JideButton((Icon)GUIHelper.getIcon("delete_all.gif"));
        this.m_ButtonRemoveAll.setButtonStyle(1);
        this.m_ButtonRemoveAll.setFont(this.getFont().deriveFont(0));
        this.m_ButtonRemoveAll.setToolTipText("Removes all");
        this.m_ButtonRemoveAll.addActionListener(e -> this.checkedRemoveAllPages());
        this.m_PanelListButtons.add((Component)this.m_ButtonRemoveAll);
        this.m_ButtonUndo = new JideButton((Icon)GUIHelper.getIcon("undo.gif"));
        this.m_ButtonUndo.setButtonStyle(1);
        this.m_ButtonUndo.setFont(this.getFont().deriveFont(0));
        this.m_ButtonUndo.setToolTipText("Undo removal");
        this.m_ButtonUndo.addActionListener(e -> this.undoPageClose());
        this.m_PanelListButtons.add((Component)this.m_ButtonUndo);
        this.m_ButtonAction = new JideSplitButton("...");
        this.m_ButtonAction.setButtonStyle(1);
        this.m_ButtonAction.setFont(this.getFont().deriveFont(0));
        this.m_ButtonAction.setAlwaysDropdown(false);
        this.m_ButtonAction.setToolTipText("Additional actions");
        this.m_ButtonAction.setVisible(false);
        this.m_PanelListButtons.add((Component)this.m_ButtonAction);
        this.m_PanelContent = new BasePanel(new BorderLayout());
        this.m_SplitPane.setRightComponent(this.m_PanelContent);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.setTitleRenderer(this.newRenderer());
        this.updateButtons();
    }

    protected TitleRenderer newRenderer() {
        return new TitleRenderer(this);
    }

    public void setReadOnly(boolean value) {
        this.m_ReadOnly = value;
        this.m_PanelListButtons.setVisible(!this.m_ReadOnly);
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    public BasePanel getButtonPanel() {
        return this.m_PanelListButtons;
    }

    public void setDividerLocation(int value) {
        this.m_SplitPane.setDividerLocation(value);
    }

    public int getDividerLocation() {
        return this.m_SplitPane.getDividerLocation();
    }

    public void setTitleRenderer(ListCellRenderer renderer) {
        this.m_PageList.setCellRenderer(renderer);
    }

    public ListCellRenderer getTitleRenderer() {
        return this.m_PageList.getCellRenderer();
    }

    public int getPageCount() {
        return this.m_PageList.getModel().getSize();
    }

    public int getSelectedIndex() {
        return this.m_PageList.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.m_PageList.setSelectedIndex(index);
    }

    public int[] getSelectedIndices() {
        return this.m_PageList.getSelectedIndices();
    }

    public void setSelectedIndices(int[] indices) {
        this.m_PageList.setSelectedIndices(indices);
    }

    public void setSelectedPage(Component page) {
        for (int i = 0; i < this.m_PageListModel.getSize(); ++i) {
            if (this.m_PageListModel.get(i).getPage() != page) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    public void setPageAt(int index, PageContainer cont) {
        this.m_PageListModel.set(index, cont);
        this.update();
    }

    public PageContainer getPageContainerAt(int index) {
        return (PageContainer)this.m_PageList.getModel().getElementAt(index);
    }

    public PageContainer getSelectedPageContainer() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.getPageContainerAt(this.getSelectedIndex());
    }

    public void setPageAt(int index, Component page) {
        this.getPageContainerAt(index).setPage(page);
        this.update();
    }

    public Component getPageAt(int index) {
        return this.getPageContainerAt(index).getPage();
    }

    public DetachablePage getDetachablePageAt(int index) {
        return this.getPageContainerAt(index).getDetachablePage();
    }

    public int indexOfPage(Component page) {
        int result = -1;
        for (int i = 0; i < this.getPageCount(); ++i) {
            if (this.getPageAt(i) != page) continue;
            result = i;
            break;
        }
        return result;
    }

    public int indexOfPage(PageContainer cont) {
        int result = -1;
        for (int i = 0; i < this.getPageCount(); ++i) {
            if (this.getPageContainerAt(i) != cont) continue;
            result = i;
            break;
        }
        return result;
    }

    public Component getSelectedPage() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.getPageAt(this.getSelectedIndex());
    }

    public DetachablePage getSelectedDetachablePage() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.getDetachablePageAt(this.getSelectedIndex());
    }

    public void setTitleAt(int index, String title) {
        this.getPageContainerAt(index).setTitle(title);
        this.update();
    }

    public String getTitleAt(int index) {
        return this.getPageContainerAt(index).getTitle();
    }

    public String getSelectedTitle() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.getTitleAt(this.getSelectedIndex());
    }

    public void setIconAt(int index, ImageIcon icon) {
        this.getPageContainerAt(index).setIcon(icon);
        this.update();
    }

    public ImageIcon getIconAt(int index) {
        return this.getPageContainerAt(index).getIcon();
    }

    public ImageIcon getSelectedIcon() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.getIconAt(this.getSelectedIndex());
    }

    protected boolean isPageClosingApproved(int index) {
        if (this.m_PageCloseApprover == null) {
            return true;
        }
        return this.m_PageCloseApprover.approvePageClosing(this, index);
    }

    protected boolean isPageClosingApproved(int[] indices) {
        int index;
        if (this.m_PageCloseApprover == null) {
            return true;
        }
        boolean result = true;
        int[] nArray = indices;
        int n = nArray.length;
        for (int i = 0; i < n && (result = this.m_PageCloseApprover.approvePageClosing(this, index = nArray[i])); ++i) {
        }
        return result;
    }

    public PageContainer checkedRemoveSelectedPage() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        if (this.isPageClosingApproved(this.getSelectedIndex())) {
            return this.removeSelectedPage();
        }
        return null;
    }

    public PageContainer removeSelectedPage() {
        if (this.getSelectedIndex() > -1) {
            return this.removePageAt(this.getSelectedIndex());
        }
        return null;
    }

    public void checkedRemoveSelectedPages() {
        if (this.getSelectedIndex() == -1) {
            return;
        }
        if (this.isPageClosingApproved(this.getSelectedIndices())) {
            this.removeSelectedPages();
        }
    }

    public void removeSelectedPages() {
        int[] indices = this.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.removePageAt(indices[i]);
        }
    }

    public PageContainer checkedRemovePageAt(int index) {
        if (this.isPageClosingApproved(index)) {
            return this.removePageAt(index);
        }
        return null;
    }

    public PageContainer removePageAt(int index) {
        this.addPageUndo(index);
        PageContainer result = this.m_PageListModel.remove(index);
        if (result.getDetachablePage().isDetached()) {
            result.getDetachablePage().reattach();
        }
        if (index < this.getPageCount()) {
            this.setSelectedIndex(index);
        } else if (index > 0) {
            this.setSelectedIndex(index - 1);
        }
        return result;
    }

    public void checkedRemoveAllPages() {
        PageContainer removed;
        this.m_IgnoreUpdates = true;
        this.m_SkipPageUndo = true;
        while (this.getPageCount() > 0 && (removed = this.checkedRemovePageAt(0)) != null) {
        }
        this.m_IgnoreUpdates = false;
        this.m_SkipPageUndo = false;
        this.update();
    }

    public void removeAllPages() {
        this.m_IgnoreUpdates = true;
        this.m_SkipPageUndo = true;
        while (this.getPageCount() > 0) {
            this.removePageAt(0);
        }
        this.m_IgnoreUpdates = false;
        this.m_SkipPageUndo = false;
        this.clearPageUndo();
        this.update();
    }

    public void addPage(String title, Component page) {
        this.addPage(new PageContainer(title, page));
    }

    public void addPage(PageContainer cont) {
        this.m_PageListModel.addElement(cont);
        this.setSelectedIndex(this.getPageCount() - 1);
    }

    public void addPage(int index, String title, Component page) {
        this.addPage(index, new PageContainer(title, page));
    }

    public void addPage(int index, PageContainer cont) {
        this.m_PageListModel.add(index, cont);
        this.setSelectedIndex(index);
    }

    public void moveUp() {
        this.m_PageList.moveUp();
    }

    public void moveDown() {
        this.m_PageList.moveDown();
    }

    public void moveTop() {
        this.m_PageList.moveTop();
    }

    public void moveBottom() {
        this.m_PageList.moveBottom();
    }

    public boolean canMoveUp() {
        return !this.m_ReadOnly && this.m_PageList.canMoveUp();
    }

    public boolean canMoveDown() {
        return !this.m_ReadOnly && this.m_PageList.canMoveDown();
    }

    public void addRemoveItemsListener(RemoveItemsListener l) {
        this.m_PageList.addRemoveItemsListener(l);
    }

    public void removeRemoveItemsListener(RemoveItemsListener l) {
        this.m_PageList.removeRemoveItemsListener(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(event);
        }
    }

    protected void update() {
        if (this.m_IgnoreUpdates) {
            return;
        }
        this.m_PanelContent.removeAll();
        DetachablePage comp = this.getSelectedDetachablePage();
        if (comp != null) {
            this.m_PanelContent.add((Component)comp, "Center");
        }
        this.m_PanelContent.invalidate();
        this.m_PanelContent.revalidate();
        this.m_PanelContent.repaint();
        this.m_PageList.repaint();
        this.updateButtons();
        this.notifyChangeListeners();
    }

    protected void updateButtons() {
        int numSelected = this.m_PageList.getSelectedIndices().length;
        this.m_ButtonUp.setEnabled(numSelected > 0 && this.canMoveUp());
        this.m_ButtonDown.setEnabled(numSelected > 0 && this.canMoveDown());
        this.m_ButtonRemove.setEnabled(numSelected > 0);
        this.m_ButtonRemoveAll.setEnabled(this.getPageCount() > 0);
        this.m_ButtonUndo.setEnabled(this.canUndoPageClose());
    }

    public void addAction(Action action) {
        if (this.m_ButtonAction.getAction() == null) {
            this.m_ButtonAction.setAction(action);
        } else {
            this.m_ButtonAction.add(action);
        }
        this.m_ButtonAction.setVisible(true);
    }

    public void addAction(JMenuItem action) {
        this.m_ButtonAction.add(action);
        this.m_ButtonAction.setVisible(true);
    }

    protected boolean processListKey(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.getSelectedIndex() > -1) {
            this.checkedRemoveSelectedPages();
            return true;
        }
        return false;
    }

    public void setPageCloseApprover(PageCloseApprover value) {
        this.m_PageCloseApprover = value;
    }

    public PageCloseApprover getPageCloseApprover() {
        return this.m_PageCloseApprover;
    }

    protected JPopupMenu createPopup(MouseEvent e) {
        DetachablePage detach;
        JPopupMenu result = new JPopupMenu();
        int index = this.getSelectedIndex();
        int[] indices = this.getSelectedIndices();
        JMenuItem menuitem = new JMenuItem("Remove");
        menuitem.setIcon(GUIHelper.getIcon("delete.gif"));
        menuitem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        menuitem.setEnabled(index > -1);
        menuitem.addActionListener(ae -> this.checkedRemoveSelectedPages());
        result.add(menuitem);
        menuitem = new JMenuItem("Remove all");
        menuitem.setIcon(GUIHelper.getIcon("delete_all.gif"));
        menuitem.setEnabled(this.m_PageListModel.getSize() > 0);
        menuitem.addActionListener(ae -> this.checkedRemoveAllPages());
        result.add(menuitem);
        if (indices.length == 1 && (detach = this.getDetachablePageAt(index)) != null) {
            String title = this.getSelectedTitle();
            result.addSeparator();
            if (detach.isDetached()) {
                menuitem = new JMenuItem("Reattach");
                menuitem.setIcon(GUIHelper.getIcon("minimize.png"));
                menuitem.addActionListener(ae -> detach.reattach());
                result.add(menuitem);
            } else {
                menuitem = new JMenuItem("Detach");
                menuitem.setIcon(GUIHelper.getIcon("maximize.png"));
                menuitem.addActionListener(ae -> {
                    this.updateTitle(title, detach);
                    detach.detach();
                });
                result.add(menuitem);
            }
        }
        return result;
    }

    protected void updateTitle(String title, DetachablePage detach) {
        detach.setFrameTitle(title);
    }

    protected void showPopup(MouseEvent e) {
        JPopupMenu menu = this.createPopup(e);
        if (this.m_PopupCustomizer != null) {
            this.m_PopupCustomizer.customizePopup(this.getSelectedIndex(), menu);
        }
        menu.show(this, e.getX(), e.getY());
    }

    public void setPopupCustomizer(PopupCustomizer value) {
        this.m_PopupCustomizer = value;
    }

    public PopupCustomizer getPopupCustomizer() {
        return this.m_PopupCustomizer;
    }

    public void setToolTipCustomizer(ToolTipCustomizer value) {
        this.m_ToolTipCustomizer = value;
    }

    public ToolTipCustomizer getToolTipCustomizer() {
        return this.m_ToolTipCustomizer;
    }

    protected String generateToolTip(int index) {
        String result = null;
        if (index >= 0 && index < this.m_PageListModel.getSize()) {
            result = this.m_PageListModel.getElementAt(index).toString();
        }
        if (this.m_ToolTipCustomizer != null) {
            result = this.m_ToolTipCustomizer.customizeToolTip(index, result);
        }
        return result;
    }

    public void setMaxPageCloseUndo(int value) {
        this.m_MaxPageCloseUndo = value;
        this.m_ButtonUndo.setVisible(this.m_MaxPageCloseUndo > 0);
    }

    public int getMaxPageCloseUndo() {
        return this.m_MaxPageCloseUndo;
    }

    protected List<PageUndo> getPageUndoList() {
        if (this.m_PageUndoList == null) {
            this.m_PageUndoList = new ArrayList<PageUndo>();
        }
        return this.m_PageUndoList;
    }

    protected void addPageUndo(int index) {
        if (this.m_MaxPageCloseUndo < 1 || this.m_SkipPageUndo) {
            return;
        }
        PageUndo undo = new PageUndo();
        undo.component = this.getPageAt(index);
        undo.title = this.getTitleAt(index);
        undo.index = index;
        undo.icon = this.getIconAt(index);
        undo.selected = index == this.getSelectedIndex();
        this.getPageUndoList().add(undo);
        while (this.getPageUndoList().size() > this.m_MaxPageCloseUndo) {
            this.getPageUndoList().remove(0);
        }
    }

    public boolean canUndoPageClose() {
        return this.getPageUndoList().size() > 0;
    }

    public boolean undoPageClose() {
        int size = this.getPageUndoList().size();
        if (size < 1) {
            return false;
        }
        PageUndo undo = this.getPageUndoList().get(size - 1);
        this.getPageUndoList().remove(size - 1);
        PageContainer cont = new PageContainer(undo.title, undo.component, undo.icon);
        this.addPage(undo.index, cont);
        if (undo.selected) {
            this.setSelectedIndex(undo.index);
        }
        return true;
    }

    protected void clearPageUndo() {
        if (this.m_PageUndoList != null) {
            this.m_PageUndoList.clear();
        }
    }

    public void cleanUp() {
        this.removeAllPages();
        this.clearPageUndo();
        this.m_PageUndoList = null;
    }

    public static class PageUndo {
        public Component component;
        public String title;
        public int index;
        public String tiptext;
        public ImageIcon icon;
        public Component tabComponent;
        public boolean selected;
    }

    public static class TitleRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 662711521384106051L;
        protected MultiPagePane m_Owner;
        protected Border m_BorderNoFocus;
        protected Border m_BorderFocused;

        public TitleRenderer(MultiPagePane owner) {
            this.m_Owner = owner;
        }

        public MultiPagePane getOwner() {
            return this.m_Owner;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.m_BorderNoFocus == null) {
                this.m_BorderNoFocus = BorderFactory.createEmptyBorder(1, 1, 1, 1);
                this.m_BorderFocused = BorderFactory.createLineBorder(list.getSelectionBackground().darker(), 1);
            }
            Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)result;
            if (cellHasFocus) {
                label.setBorder(this.m_BorderFocused);
            } else {
                label.setBorder(this.m_BorderNoFocus);
            }
            PageContainer cont = (PageContainer)list.getModel().getElementAt(index);
            label.setIcon(cont.getIcon());
            return result;
        }
    }

    public static interface ToolTipCustomizer {
        public String customizeToolTip(int var1, String var2);
    }

    public static interface PopupCustomizer {
        public void customizePopup(int var1, JPopupMenu var2);
    }

    public static interface PageCloseApprover {
        public boolean approvePageClosing(MultiPagePane var1, int var2);
    }

    public static class PageContainer
    implements Serializable {
        private static final long serialVersionUID = -7918640108273902031L;
        protected String m_Title;
        protected Component m_Page;
        protected DetachablePage m_DetachablePage;
        protected ImageIcon m_Icon;

        public PageContainer(String title, Component page) {
            this(title, page, null);
        }

        public PageContainer(String title, Component page, ImageIcon icon) {
            this.m_Title = title;
            this.m_Page = page;
            this.m_Icon = icon;
            this.m_DetachablePage = new DetachablePage(page);
        }

        public String getTitle() {
            return this.m_Title;
        }

        public void setTitle(String value) {
            this.m_Title = value;
        }

        public Component getPage() {
            return this.m_Page;
        }

        public void setPage(Component value) {
            this.m_Page = value;
            this.m_DetachablePage.getContentPanel().removeAll();
            this.m_DetachablePage.getContentPanel().add(value, "Center");
            this.m_DetachablePage.getContentPanel().invalidate();
            this.m_DetachablePage.getContentPanel().revalidate();
            this.m_DetachablePage.getContentPanel().repaint();
        }

        public DetachablePage getDetachablePage() {
            return this.m_DetachablePage;
        }

        public String toString() {
            return this.m_Title;
        }

        public ImageIcon getIcon() {
            return this.m_Icon;
        }

        public void setIcon(ImageIcon value) {
            this.m_Icon = value;
        }
    }

    public static class DetachablePage
    extends DetachablePanel {
        private static final long serialVersionUID = 1968992223273451733L;
        protected Component m_Component;

        public DetachablePage(Component comp) {
            this.m_Component = comp;
            this.getContentPanel().add(this.m_Component, "Center");
        }

        public Component getComponent() {
            return this.m_Component;
        }
    }
}

