/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import nz.ac.waikato.cms.core.FileUtils;

public class PropsUtils {
    public static boolean load(Properties props, String filename) {
        boolean result = true;
        try {
            props.clear();
            File file = new File(filename);
            if (file.exists()) {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
                props.load(stream);
                stream.close();
            } else {
                System.err.println("file '" + filename + "' does not exist - skipped!");
            }
        }
        catch (Exception e) {
            props.clear();
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public static boolean save(Properties props, String filename) {
        return PropsUtils.save(props, filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(Properties props, String filename, String comment) {
        boolean result = true;
        OutputStream fos = null;
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(filename));
            props.store(stream, comment);
            stream.flush();
        }
        catch (Exception e) {
            try {
                result = false;
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(stream);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly(stream);
            FileUtils.closeQuietly(fos);
        }
        FileUtils.closeQuietly(stream);
        FileUtils.closeQuietly(fos);
        return result;
    }
}

