/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.awt.Font;
import nz.ac.waikato.cms.gui.core.AbstractChooserPanel;
import nz.ac.waikato.cms.gui.core.FontChooser;
import nz.ac.waikato.cms.gui.core.GUIHelper;

public class FontChooserPanel
extends AbstractChooserPanel<Font> {
    private static final long serialVersionUID = -8755020252465094120L;
    protected FontChooser m_FontChooser;

    public FontChooserPanel() {
        this(Font.decode("sans"));
    }

    public FontChooserPanel(Font font) {
        this.setCurrent(font);
    }

    @Override
    protected int getSelectionColumns() {
        return 10;
    }

    @Override
    protected Font doChoose() {
        if (this.m_FontChooser == null) {
            this.m_FontChooser = GUIHelper.getParentDialog(this) != null ? new FontChooser(GUIHelper.getParentDialog(this)) : new FontChooser(GUIHelper.getParentFrame(this));
        }
        this.m_FontChooser.setCurrent((Font)this.getCurrent());
        this.m_FontChooser.setVisible(true);
        return this.m_FontChooser.getCurrent();
    }

    @Override
    protected String toString(Font value) {
        return FontChooserPanel.encodeFont(value);
    }

    @Override
    protected Font fromString(String value) {
        return Font.decode(value);
    }

    public static String encodeFont(Font f) {
        String face = f.isBold() && f.isItalic() ? "BOLDITALIC" : (f.isBold() ? "BOLD" : (f.isItalic() ? "ITALIC" : "PLAIN"));
        String result = f.getName() + "-" + face + "-" + f.getSize();
        return result;
    }
}

