/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import com.jidesoft.swing.FolderChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import nz.ac.waikato.cms.gui.core.DirectoryBookmarks;
import nz.ac.waikato.cms.gui.core.GUIHelper;

public class BaseDirectoryChooser
extends FolderChooser {
    private static final long serialVersionUID = -7252242971482953986L;
    protected DirectoryBookmarks.FileChooserBookmarksPanel m_PanelBookmarks;
    protected JButton m_ButtonBookmarks;

    public BaseDirectoryChooser() {
        this.initialize();
    }

    public BaseDirectoryChooser(File currentDirectory) {
        super(currentDirectory.getAbsoluteFile());
        this.initialize();
    }

    public BaseDirectoryChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory.getAbsoluteFile(), fsv);
        this.initialize();
    }

    public BaseDirectoryChooser(FileSystemView fsv) {
        super(fsv);
        this.initialize();
    }

    public BaseDirectoryChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.initialize();
    }

    public BaseDirectoryChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.initialize();
    }

    protected void initialize() {
        this.setRecentListVisible(false);
        JComponent accessory = this.createAccessoryPanel();
        if (accessory != null) {
            this.setAccessory(accessory);
        }
        this.showBookmarks(false);
        this.setPreferredSize(new Dimension(400, 500));
    }

    protected JComponent createAccessoryPanel() {
        JPanel result = new JPanel(new BorderLayout());
        this.m_ButtonBookmarks = new JButton(GUIHelper.getIcon("arrow-head-up.png"));
        this.m_ButtonBookmarks.setBorder(BorderFactory.createEmptyBorder());
        this.m_ButtonBookmarks.setPreferredSize(new Dimension(18, 18));
        this.m_ButtonBookmarks.setBorderPainted(false);
        this.m_ButtonBookmarks.setContentAreaFilled(false);
        this.m_ButtonBookmarks.setFocusPainted(false);
        this.m_ButtonBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDirectoryChooser.this.showBookmarks(!BaseDirectoryChooser.this.m_PanelBookmarks.isVisible());
            }
        });
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this.m_ButtonBookmarks);
        result.add((Component)panel, "North");
        this.m_PanelBookmarks = new DirectoryBookmarks.FileChooserBookmarksPanel();
        this.m_PanelBookmarks.setOwner((JFileChooser)((Object)this));
        this.m_PanelBookmarks.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 0));
        result.add((Component)((Object)this.m_PanelBookmarks), "Center");
        return result;
    }

    protected void showBookmarks(boolean value) {
        this.m_PanelBookmarks.setVisible(value);
        if (this.m_PanelBookmarks.isVisible()) {
            this.m_ButtonBookmarks.setIcon(GUIHelper.getIcon("arrow-head-up.png"));
        } else {
            this.m_ButtonBookmarks.setIcon(GUIHelper.getIcon("arrow-head-down.png"));
        }
    }

    public void addChoosableFileFilter(FileFilter filter) {
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        this.m_PanelBookmarks.reload();
        this.m_PanelBookmarks.updateButtons();
        return super.showDialog(parent, approveButtonText);
    }

    public static void main(String[] args) {
        BaseDirectoryChooser chooser = new BaseDirectoryChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("java.io.tmpdir")));
        if (chooser.showOpenDialog(null) == 0) {
            System.out.println(chooser.getSelectedFile());
        }
    }
}

