/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableHelper {
    protected static Logger LOGGER = Logger.getLogger(JTableHelper.class.getName());
    public static final int MAX_ROWS = 100;
    protected JTable m_Table;

    public JTableHelper(JTable table) {
        this.m_Table = table;
    }

    public JTable getJTable() {
        return this.m_Table;
    }

    public int calcColumnWidth(int col) {
        return this.calcColumnWidthBounded(col, -1);
    }

    public int calcColumnWidthBounded(int col, int max) {
        return JTableHelper.calcColumnWidthBounded(this.getJTable(), col, max);
    }

    public static int calcColumnWidth(JTable table, int col) {
        return JTableHelper.calcColumnWidthBounded(table, col, -1);
    }

    public static int calcColumnWidthBounded(JTable table, int col, int max) {
        int result = JTableHelper.calcHeaderWidthBounded(table, col, max);
        if (result == -1) {
            return result;
        }
        if (max > -1 && result >= max) {
            return result;
        }
        TableModel data = table.getModel();
        int rowCount = data.getRowCount();
        int dec = (int)Math.ceil((double)rowCount / 100.0);
        try {
            for (int row = rowCount - 1; row >= 0; row -= dec) {
                Component c = table.prepareRenderer(table.getCellRenderer(row, col), row, col);
                result = Math.max(result, c.getPreferredSize().width + 10);
                if (max <= -1 || result < max) continue;
                result = max;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to calculate column width!", e);
        }
        return result;
    }

    public int calcHeaderWidth(int col) {
        return JTableHelper.calcHeaderWidthBounded(this.getJTable(), col, -1);
    }

    public int calcHeaderWidthBounded(int col, int max) {
        return JTableHelper.calcHeaderWidthBounded(this.getJTable(), col, max);
    }

    public static int calcHeaderWidth(JTable table, int col) {
        return JTableHelper.calcHeaderWidthBounded(table, col, -1);
    }

    public static int calcHeaderWidthBounded(JTable table, int col, int max) {
        if (table == null) {
            return -1;
        }
        if (col < 0 || col > table.getColumnCount()) {
            LOGGER.severe("calcHeaderWidth: invalid col " + col);
            return -1;
        }
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableColumn column = columns.getColumn(col);
        int width = -1;
        TableCellRenderer h = column.getHeaderRenderer();
        if (h == null) {
            h = defaultHeaderRenderer;
        }
        if (h != null) {
            Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, col);
            width = c.getPreferredSize().width + 5;
        }
        if (max > -1) {
            width = Math.min(width, max);
        }
        return width;
    }

    public void setOptimalColumnWidth(int col) {
        JTableHelper.setOptimalColumnWidthBounded(this.getJTable(), col, -1);
    }

    public void setOptimalColumnWidthBounded(int col, int max) {
        JTableHelper.setOptimalColumnWidthBounded(this.getJTable(), col, max);
    }

    public static void setOptimalColumnWidth(JTable table, int col) {
        JTableHelper.setOptimalHeaderWidthBounded(table, col, -1);
    }

    public static void setOptimalColumnWidthBounded(JTable table, int col, int max) {
        int width;
        if (col >= 0 && col < table.getColumnModel().getColumnCount() && (width = JTableHelper.calcColumnWidthBounded(table, col, max)) >= 0) {
            SwingUtilities.invokeLater(() -> {
                JTableHeader header = table.getTableHeader();
                TableColumn column = table.getColumnModel().getColumn(col);
                column.setPreferredWidth(width);
                table.doLayout();
                header.repaint();
            });
        }
    }

    public void setOptimalColumnWidth() {
        JTableHelper.setOptimalColumnWidthBounded(this.getJTable(), -1);
    }

    public void setOptimalColumnWidthBounded(int max) {
        JTableHelper.setOptimalColumnWidthBounded(this.getJTable(), max);
    }

    public static void setOptimalColumnWidth(JTable table) {
        JTableHelper.setOptimalColumnWidthBounded(table, -1);
    }

    public static void setOptimalColumnWidthBounded(JTable table, int max) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalColumnWidthBounded(table, i, max);
        }
    }

    public void setOptimalHeaderWidth(int col) {
        JTableHelper.setOptimalHeaderWidthBounded(this.getJTable(), col, -1);
    }

    public void setOptimalHeaderWidthBounded(int col, int max) {
        JTableHelper.setOptimalHeaderWidthBounded(this.getJTable(), col, max);
    }

    public static void setOptimalHeaderWidth(JTable table, int col) {
        JTableHelper.setOptimalHeaderWidthBounded(table, col, -1);
    }

    public static void setOptimalHeaderWidthBounded(JTable table, int col, int max) {
        int width;
        if (col >= 0 && col < table.getColumnModel().getColumnCount() && (width = JTableHelper.calcHeaderWidthBounded(table, col, max)) >= 0) {
            SwingUtilities.invokeLater(() -> {
                JTableHeader header = table.getTableHeader();
                TableColumn column = table.getColumnModel().getColumn(col);
                column.setPreferredWidth(width);
                table.doLayout();
                header.repaint();
            });
        }
    }

    public void setOptimalHeaderWidth() {
        JTableHelper.setOptimalHeaderWidth(this.getJTable());
    }

    public static void setOptimalHeaderWidth(JTable table) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(table, i);
        }
    }

    public void scrollToVisible(int row, int col) {
        JTableHelper.scrollToVisible(this.getJTable(), row, col);
    }

    public static void scrollToVisible(JTable table, int row, int col) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(row, col, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }
}

