/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import nz.ac.waikato.cms.core.FileUtils;
import nz.ac.waikato.cms.gui.core.AbstractChooserPanel;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;
import nz.ac.waikato.cms.gui.core.BasePanel;
import nz.ac.waikato.cms.gui.core.BaseScrollPane;
import nz.ac.waikato.cms.gui.core.DirectoryChooserPanel;
import nz.ac.waikato.cms.gui.core.ExtensionFileFilter;
import nz.ac.waikato.cms.gui.core.FileChooserPanel;
import nz.ac.waikato.cms.gui.core.GUIHelper;
import nz.ac.waikato.cms.gui.core.ParameterPanel;

public class PropertiesParameterPanel
extends BasePanel {
    private static final long serialVersionUID = -822178750857036833L;
    public static final int DEFAULT_WIDTH_CHOOSERS = 250;
    protected ParameterPanel m_PanelProperties;
    protected List<String> m_Identifiers;
    protected HashMap<String, PropertyType> m_PropertyTypes;
    protected HashMap<String, PropertyType> m_ActualPropertyTypes;
    protected HashMap<String, AbstractChooserPanel> m_Choosers;
    protected HashMap<String, String[]> m_Lists;
    protected HashMap<String, String> m_Help;
    protected HashMap<String, String> m_Label;
    protected HashMap<String, Component> m_Component;
    protected List<String> m_Order;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonLoad;
    protected JButton m_ButtonSave;
    protected BaseFileChooser m_FileChooser;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Identifiers = new ArrayList<String>();
        this.m_PropertyTypes = new HashMap();
        this.m_ActualPropertyTypes = new HashMap();
        this.m_Choosers = new HashMap();
        this.m_Lists = new HashMap();
        this.m_Help = new HashMap();
        this.m_Label = new HashMap();
        this.m_Component = new HashMap();
        this.m_Order = new ArrayList<String>();
        this.m_FileChooser = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelProperties = new ParameterPanel();
        this.add((Component)new BaseScrollPane(this.m_PanelProperties), "Center");
        this.m_PanelButtons = new JPanel(new BorderLayout());
        this.add((Component)this.m_PanelButtons, "South");
        JPanel panel = new JPanel(new FlowLayout(0));
        this.m_PanelButtons.add((Component)panel, "West");
        this.m_ButtonLoad = new JButton(GUIHelper.getIcon("open.gif"));
        this.m_ButtonLoad.addActionListener(e -> this.loadProperties());
        panel.add(this.m_ButtonLoad);
        this.m_ButtonSave = new JButton(GUIHelper.getIcon("save.gif"));
        this.m_ButtonSave.addActionListener(e -> this.saveProperties());
        panel.add(this.m_ButtonSave);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.setButtonPanelVisible(false);
    }

    public void clearPropertyTypes() {
        this.m_PropertyTypes.clear();
        this.m_ActualPropertyTypes.clear();
        this.m_Choosers.clear();
        this.m_Lists.clear();
        this.m_Help.clear();
    }

    protected void clearProperties() {
        this.m_Identifiers.clear();
        this.m_PanelProperties.clearParameters();
    }

    public void addProperty(String identifier, String label, Component comp) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelProperties.addParameter(label, comp);
    }

    public void addProperty(String identifier, String label, AbstractChooserPanel chooser) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelProperties.addParameter(label, (Component)chooser);
    }

    public Component getProperty(int index) {
        return this.m_PanelProperties.getParameter(index);
    }

    public Component getProperty(String identifier) {
        int index = this.m_Identifiers.indexOf(identifier);
        if (index == -1) {
            return null;
        }
        return this.m_PanelProperties.getParameter(index);
    }

    public int getPropertyCount() {
        return this.m_PanelProperties.getParameterCount();
    }

    public void addPropertyType(String property, PropertyType type) {
        this.m_PropertyTypes.put(property, type);
    }

    public boolean hasPropertyType(String property) {
        return this.m_PropertyTypes.containsKey(property);
    }

    public PropertyType getPropertyType(String property) {
        if (this.hasPropertyType(property)) {
            return this.m_PropertyTypes.get(property);
        }
        return PropertyType.STRING;
    }

    public PropertyType getActualPropertyType(String property) {
        if (this.m_ActualPropertyTypes.containsKey(property)) {
            return this.m_ActualPropertyTypes.get(property);
        }
        return PropertyType.STRING;
    }

    public void setPropertyOrder(String[] value) {
        this.setPropertyOrder(Arrays.asList(value));
    }

    public void setPropertyOrder(List<String> value) {
        this.m_Order.clear();
        this.m_Order.addAll(value);
    }

    public List<String> getPropertyOrder() {
        return this.m_Order;
    }

    public boolean hasChooser(String property) {
        return this.m_Choosers.containsKey(property);
    }

    public void setChooser(String property, AbstractChooserPanel value) {
        this.m_Choosers.put(property, value);
    }

    public AbstractChooserPanel getChooser(String property) {
        return this.m_Choosers.get(property);
    }

    public boolean hasComponent(String property) {
        return this.m_Component.containsKey(property);
    }

    public void setComponent(String property, Component value) {
        this.m_Component.put(property, value);
    }

    public Component getComponent(String property) {
        return this.m_Component.get(property);
    }

    public boolean hasList(String property) {
        return this.m_Lists.containsKey(property);
    }

    public void setList(String property, String[] value) {
        this.m_Lists.put(property, value);
    }

    public String[] getList(String property) {
        return this.m_Lists.get(property);
    }

    public boolean hasHelp(String property) {
        return this.m_Help.containsKey(property);
    }

    public void setHelp(String property, String value) {
        this.m_Help.put(property, value);
    }

    public String getHelp(String property) {
        return this.m_Help.get(property);
    }

    public boolean hasLabel(String property) {
        return this.m_Label.containsKey(property);
    }

    public void setLabel(String property, String value) {
        this.m_Label.put(property, value);
    }

    public String getLabel(String property) {
        return this.m_Label.get(property);
    }

    protected PropertyType fixPropertyType(String key, PropertyType type) {
        if (type == PropertyType.CUSTOM_COMPONENT) {
            if (!this.hasComponent(key)) {
                type = PropertyType.STRING;
            }
        } else if (type == PropertyType.LIST && !this.hasList(key)) {
            type = PropertyType.STRING;
        }
        return type;
    }

    protected void updateToolTipText(Component comp, String help) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setToolTipText(help);
        }
    }

    protected void setText(Component comp, String text) {
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setText(text);
        } else {
            try {
                Method method = comp.getClass().getMethod("setText", String.class);
                method.invoke((Object)comp, text);
            }
            catch (Exception e) {
                throw new IllegalStateException("Class " + comp.getClass().getName() + " has no setText(String) method!");
            }
        }
    }

    protected String getText(Component comp) {
        if (comp instanceof JTextComponent) {
            return ((JTextComponent)comp).getText();
        }
        try {
            Method method = comp.getClass().getMethod("getText", new Class[0]);
            return (String)method.invoke((Object)comp, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Class " + comp.getClass().getName() + " has no getText() method that returns a String object!");
        }
    }

    public void setProperties(Properties value) {
        this.clearProperties();
        ArrayList<String> keys = new ArrayList<String>(value.stringPropertyNames());
        keys.removeAll(this.m_Order);
        Collections.sort(keys);
        keys.addAll(0, this.m_Order);
        for (String key : keys) {
            PropertyType type = this.fixPropertyType(key, this.getPropertyType(key));
            String help = this.getHelp(key);
            this.m_ActualPropertyTypes.put(key, type);
            String label = this.hasLabel(key) ? this.getLabel(key) : key;
            try {
                switch (type) {
                    case DOUBLE: {
                        final JTextField textfield = new JTextField(20);
                        textfield.setText(value.getProperty(key));
                        textfield.setToolTipText(help);
                        textfield.setBorder(BorderFactory.createEtchedBorder());
                        textfield.getDocument().addDocumentListener(new DocumentListener(){

                            @Override
                            public void removeUpdate(DocumentEvent e) {
                                this.check(e);
                            }

                            @Override
                            public void insertUpdate(DocumentEvent e) {
                                this.check(e);
                            }

                            @Override
                            public void changedUpdate(DocumentEvent e) {
                                this.check(e);
                            }

                            protected void check(DocumentEvent e) {
                                String text = textfield.getText();
                                boolean isDouble = true;
                                try {
                                    Double.parseDouble(text);
                                }
                                catch (Exception ex) {
                                    isDouble = false;
                                }
                                if (text.length() == 0 || isDouble) {
                                    textfield.setBorder(BorderFactory.createEtchedBorder());
                                } else {
                                    textfield.setBorder(BorderFactory.createLineBorder(Color.RED));
                                }
                            }
                        });
                        this.addProperty(key, label, textfield);
                        break;
                    }
                    case STRING: {
                        final JTextField textfield = new JTextField();
                        textfield.setText(value.getProperty(key));
                        textfield.setToolTipText(help);
                        this.addProperty(key, label, textfield);
                        break;
                    }
                    case BOOLEAN: {
                        JCheckBox checkbox = new JCheckBox();
                        checkbox.setSelected(Boolean.parseBoolean(value.getProperty(key)));
                        checkbox.setToolTipText(help);
                        this.addProperty(key, label, checkbox);
                        break;
                    }
                    case INTEGER: {
                        JSpinner spinner = new JSpinner();
                        spinner.setValue(Integer.parseInt(value.getProperty(key)));
                        spinner.setToolTipText(help);
                        this.addProperty(key, label, spinner);
                        break;
                    }
                    case LONG: {
                        JSpinner spinner = new JSpinner();
                        spinner.setValue(Long.parseLong(value.getProperty(key)));
                        spinner.setToolTipText(help);
                        this.addProperty(key, label, spinner);
                        break;
                    }
                    case DIRECTORY: 
                    case DIRECTORY_ABSOLUTE: {
                        DirectoryChooserPanel dirPanel = new DirectoryChooserPanel();
                        dirPanel.setCurrent(new File(value.getProperty(key)));
                        dirPanel.setPreferredSize(new Dimension(250, dirPanel.getPreferredSize().height));
                        dirPanel.setToolTipText(help);
                        dirPanel.setInlineEditingEnabled(true);
                        this.addProperty(key, label, dirPanel);
                        break;
                    }
                    case FILE: 
                    case FILE_ABSOLUTE: {
                        FileChooserPanel filePanel = new FileChooserPanel();
                        filePanel.setCurrent(new File(value.getProperty(key)));
                        filePanel.setPreferredSize(new Dimension(250, filePanel.getPreferredSize().height));
                        filePanel.setToolTipText(help);
                        filePanel.setInlineEditingEnabled(true);
                        this.addProperty(key, label, filePanel);
                        break;
                    }
                    case LIST: 
                    case BLANK_SEPARATED_LIST_FIXED: 
                    case COMMA_SEPARATED_LIST_FIXED: {
                        JComboBox<String> combo = type == PropertyType.BLANK_SEPARATED_LIST_FIXED ? new JComboBox<String>(value.getProperty(key).split(" ")) : (type == PropertyType.COMMA_SEPARATED_LIST_FIXED ? new JComboBox<String>(value.getProperty(key).split(",")) : new JComboBox<String>(this.getList(key)));
                        combo.setSelectedItem(value.getProperty(key));
                        combo.setToolTipText(help);
                        this.addProperty(key, label, combo);
                        break;
                    }
                    case CUSTOM_COMPONENT: {
                        Component comp = this.getComponent(key);
                        this.setText(comp, value.getProperty(key));
                        this.updateToolTipText(comp, help);
                        this.addProperty(key, label, this.getComponent(key));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled property type (property '" + keys + "'): " + (Object)((Object)type));
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to set property/type: '" + key + "'/" + (Object)((Object)type));
                e.printStackTrace();
            }
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public Properties getProperties() {
        Properties result = new Properties();
        block13: for (int i = 0; i < this.getPropertyCount(); ++i) {
            Component comp = this.getProperty(i);
            String key = this.m_Identifiers.get(i);
            PropertyType type = this.getActualPropertyType(key);
            switch (type) {
                case DOUBLE: {
                    JTextField textfield = (JTextField)comp;
                    result.setProperty(key, textfield.getText());
                    continue block13;
                }
                case STRING: {
                    JTextField textfield = (JTextField)comp;
                    result.setProperty(key, textfield.getText());
                    continue block13;
                }
                case BOOLEAN: {
                    JCheckBox checkbox = (JCheckBox)comp;
                    result.setProperty(key, "" + checkbox.isSelected());
                    continue block13;
                }
                case INTEGER: {
                    JSpinner spinner = (JSpinner)comp;
                    result.setProperty(key, "" + ((Number)spinner.getValue()).intValue());
                    continue block13;
                }
                case LONG: {
                    JSpinner spinner = (JSpinner)comp;
                    result.setProperty(key, "" + ((Number)spinner.getValue()).longValue());
                    continue block13;
                }
                case DIRECTORY: {
                    DirectoryChooserPanel dirPanel = (DirectoryChooserPanel)comp;
                    result.setProperty(key, ((File)dirPanel.getCurrent()).getPath());
                    continue block13;
                }
                case DIRECTORY_ABSOLUTE: {
                    DirectoryChooserPanel dirPanel = (DirectoryChooserPanel)comp;
                    result.setProperty(key, ((File)dirPanel.getCurrent()).getAbsolutePath());
                    continue block13;
                }
                case FILE: {
                    FileChooserPanel filePanel = (FileChooserPanel)comp;
                    result.setProperty(key, ((File)filePanel.getCurrent()).getPath());
                    continue block13;
                }
                case FILE_ABSOLUTE: {
                    FileChooserPanel filePanel = (FileChooserPanel)comp;
                    result.setProperty(key, ((File)filePanel.getCurrent()).getAbsolutePath());
                    continue block13;
                }
                case LIST: 
                case BLANK_SEPARATED_LIST_FIXED: 
                case COMMA_SEPARATED_LIST_FIXED: {
                    JComboBox comboEnum = (JComboBox)comp;
                    if (comboEnum.getSelectedIndex() <= -1) continue block13;
                    result.setProperty(key, "" + comboEnum.getSelectedItem());
                    continue block13;
                }
                case CUSTOM_COMPONENT: {
                    result.setProperty(key, this.getText(comp));
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("Unhandled property type (property '" + key + "'): " + (Object)((Object)type));
                }
            }
        }
        return result;
    }

    protected synchronized BaseFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new BaseFileChooser();
            ExtensionFileFilter filter = ExtensionFileFilter.getPropertiesFileFilter();
            this.m_FileChooser.addChoosableFileFilter(filter);
            this.m_FileChooser.setFileFilter(filter);
        }
        return this.m_FileChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() {
        int retVal = this.getFileChooser().showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        FileReader freader = null;
        BufferedReader breader = null;
        Properties props = new Properties();
        try {
            freader = new FileReader(this.getFileChooser().getSelectedFile().getAbsolutePath());
            breader = new BufferedReader(freader);
            props.load(breader);
        }
        catch (Exception e) {
            try {
                GUIHelper.showErrorMessage(this, "Failed to load properties from: " + this.getFileChooser().getSelectedFile());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly(freader);
                throw throwable;
            }
            FileUtils.closeQuietly(breader);
            FileUtils.closeQuietly(freader);
            return;
        }
        FileUtils.closeQuietly(breader);
        FileUtils.closeQuietly(freader);
        this.setProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProperties() {
        int retVal = this.getFileChooser().showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        FileWriter fwriter = null;
        BufferedWriter bwriter = null;
        Properties props = this.getProperties();
        try {
            fwriter = new FileWriter(this.getFileChooser().getSelectedFile().getAbsolutePath());
            bwriter = new BufferedWriter(fwriter);
            props.store(bwriter, null);
        }
        catch (Exception e) {
            try {
                GUIHelper.showErrorMessage(this, "Failed to save properties to: " + this.getFileChooser().getSelectedFile());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(bwriter);
                FileUtils.closeQuietly(fwriter);
                throw throwable;
            }
            FileUtils.closeQuietly(bwriter);
            FileUtils.closeQuietly(fwriter);
        }
        FileUtils.closeQuietly(bwriter);
        FileUtils.closeQuietly(fwriter);
    }

    public void setButtonPanelVisible(boolean value) {
        this.m_PanelButtons.setVisible(value);
    }

    public boolean isButtonPanelVisible() {
        return this.m_PanelButtons.isVisible();
    }

    public void addChangeListener(ChangeListener l) {
        this.m_PanelProperties.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_PanelProperties.removeChangeListener(l);
    }

    public static enum PropertyType {
        BOOLEAN,
        INTEGER,
        LONG,
        DOUBLE,
        STRING,
        FILE,
        FILE_ABSOLUTE,
        DIRECTORY,
        DIRECTORY_ABSOLUTE,
        LIST,
        COMMA_SEPARATED_LIST_FIXED,
        BLANK_SEPARATED_LIST_FIXED,
        CUSTOM_COMPONENT;

    }
}

