/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import nz.ac.waikato.cms.gui.core.AbstractChooserPanel;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;

public class FileChooserPanel
extends AbstractChooserPanel<File> {
    private static final long serialVersionUID = -8755020252465094120L;
    protected BaseFileChooser m_FileChooser;
    protected boolean m_UseSaveDialog;

    public FileChooserPanel() {
        this("");
    }

    public FileChooserPanel(String path) {
        this(new File(path));
    }

    public FileChooserPanel(File path) {
        this.setCurrent(path);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        this.m_UseSaveDialog = false;
    }

    @Override
    protected File doChoose() {
        this.m_FileChooser.setSelectedFile((File)this.getCurrent());
        if (this.m_UseSaveDialog) {
            if (this.m_FileChooser.showSaveDialog(this.m_Self) == 0) {
                return this.m_FileChooser.getSelectedFile();
            }
            return null;
        }
        if (this.m_FileChooser.showOpenDialog(this.m_Self) == 0) {
            return this.m_FileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    protected String toString(File value) {
        String result = value.getAbsolutePath();
        if (result.equals(System.getProperty("user.dir"))) {
            result = ".";
        }
        return result;
    }

    @Override
    protected File fromString(String value) {
        return new File(value);
    }

    public void setFileSelectionMode(int value) {
        this.m_FileChooser.setFileSelectionMode(value);
    }

    public int getFileSelectionMode() {
        return this.m_FileChooser.getFileSelectionMode();
    }

    public void addChoosableFileFilter(FileFilter value) {
        FileFilter current = this.m_FileChooser.getFileFilter();
        this.m_FileChooser.addChoosableFileFilter(value);
        this.m_FileChooser.setFileFilter(current);
    }

    public void removeChoosableFileFilter(FileFilter value) {
        this.m_FileChooser.removeChoosableFileFilter(value);
    }

    public void removeChoosableFileFilters() {
        FileFilter[] filters;
        for (FileFilter filter : filters = this.m_FileChooser.getChoosableFileFilters()) {
            this.m_FileChooser.removeChoosableFileFilter(filter);
        }
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.m_FileChooser.getChoosableFileFilters();
    }

    public void setAcceptAllFileFilterUsed(boolean value) {
        this.m_FileChooser.setAcceptAllFileFilterUsed(value);
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.m_FileChooser.isAcceptAllFileFilterUsed();
    }

    public void setFileFilter(FileFilter value) {
        this.m_FileChooser.setFileFilter(value);
    }

    public FileFilter getFileFilter() {
        return this.m_FileChooser.getFileFilter();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(value);
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    @Override
    public boolean setCurrent(File value) {
        boolean result = super.setCurrent(value);
        this.m_FileChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        return result;
    }

    public void setUseSaveDialog(boolean value) {
        this.m_UseSaveDialog = value;
    }

    public boolean getUseSaveDialog() {
        return this.m_UseSaveDialog;
    }
}

