/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static final String ARRAY_INDICATOR = "[]";

    public static Class getArrayClass(Class c) {
        if (c.getComponentType().isArray()) {
            return Utils.getArrayClass(c.getComponentType());
        }
        return c.getComponentType();
    }

    public static int getArrayDimensions(Class array) {
        if (array.getComponentType().isArray()) {
            return 1 + Utils.getArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object array) {
        return Utils.getArrayDimensions(array.getClass());
    }

    public static String arrayToString(Object array, boolean outputClass) {
        StringBuilder result = new StringBuilder();
        int dimensions = Utils.getArrayDimensions(array);
        if (dimensions == 0) {
            result.append("null");
        } else if (dimensions == 1) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                if (Array.get(array, i) == null) {
                    result.append("null");
                    continue;
                }
                Object obj = Array.get(array, i);
                if (outputClass) {
                    if (obj instanceof Class) {
                        result.append(((Class)obj).getName());
                        continue;
                    }
                    result.append(obj.getClass().getName());
                    continue;
                }
                result.append(obj.toString());
            }
        } else {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append("[" + Utils.arrayToString(Array.get(array, i)) + "]");
            }
        }
        return result.toString();
    }

    public static String arrayToString(Object array) {
        return Utils.arrayToString(array, false);
    }

    public static String flatten(List lines, String sep) {
        return Utils.flatten(lines.toArray(new Object[lines.size()]), sep);
    }

    public static String flatten(Object[] lines, String sep) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(lines[i].toString());
        }
        return result.toString();
    }

    public static Class stringToClass(String classname) {
        Class<?> result = null;
        int arrayDim = 0;
        if (classname.endsWith(ARRAY_INDICATOR)) {
            String arrays = classname.substring(classname.indexOf(ARRAY_INDICATOR));
            arrays = arrays.replace("][", "],[");
            arrayDim = arrays.split(",").length;
            classname = classname.substring(0, classname.indexOf(ARRAY_INDICATOR));
        }
        try {
            result = Class.forName(classname);
            for (int i = 0; i < arrayDim; ++i) {
                result = Array.newInstance(result, 0).getClass();
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static Object newArray(String elementClass, int length) {
        Object result;
        try {
            result = Array.newInstance(Utils.stringToClass(elementClass), length);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String classToString(Class c) {
        String result;
        if (c.isArray()) {
            int dim = Utils.getArrayDimensions(c);
            result = Utils.getArrayClass(c).getName();
            for (int i = 0; i < dim; ++i) {
                result = result + ARRAY_INDICATOR;
            }
        } else {
            result = c.getName();
        }
        return result;
    }

    public static String classesToString(Class[] c) {
        return Utils.classesToString(c, ", ");
    }

    public static String classesToString(Class[] c, String separator) {
        StringBuilder result = new StringBuilder();
        for (Class cls : c) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(Utils.classToString(cls));
        }
        return result.toString();
    }

    public static float[] toFloat(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }

    public static double[] toDouble(float[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static String padLeft(String s, char padding, int width) {
        return Utils.padLeft(s, padding, width, false);
    }

    public static String padLeft(String s, char padding, int width, boolean truncate) {
        StringBuilder result = new StringBuilder(s);
        while (result.length() < width) {
            result.insert(0, padding);
        }
        if (truncate && result.length() > width) {
            result.delete(0, result.length() - width);
        }
        return result.toString();
    }

    public static String throwableToString(Throwable t) {
        return Utils.throwableToString(t, -1);
    }

    public static String throwableToString(Throwable t, int maxLines) {
        StringBuilder result;
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        if (maxLines > 0) {
            result = new StringBuilder();
            String[] lines = writer.toString().split("\n");
            for (int i = 0; i < maxLines; ++i) {
                if (i > 0) {
                    result.append("\n");
                }
                result.append(lines[i]);
            }
        } else {
            result = new StringBuilder(writer.toString());
        }
        return result.toString();
    }

    public static String getStackTrace(int maxDepth) {
        StringBuilder result = new StringBuilder();
        Throwable th = new Throwable();
        th.fillInStackTrace();
        StackTraceElement[] trace = th.getStackTrace();
        if (maxDepth <= 0) {
            maxDepth = trace.length - 1;
        }
        ++maxDepth;
        maxDepth = Math.min(maxDepth, trace.length);
        for (int i = 1; i < maxDepth; ++i) {
            if (i > 1) {
                result.append("\n");
            }
            result.append(trace[i]);
        }
        return result.toString();
    }

    public static List<Integer> toBase(int n, int base) {
        int times;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int current = n;
        do {
            times = current / base;
            int remainder = current - times * base;
            result.add(remainder);
            current = times;
        } while (times > 0);
        return result;
    }

    public static String[] split(String line, char delimiter) {
        return Utils.split(line, "" + delimiter);
    }

    public static String[] split(String line, String delimiter) {
        int currPos;
        ArrayList<String> result = new ArrayList<String>();
        int lastPos = -1;
        while ((currPos = line.indexOf(delimiter, lastPos + 1)) > -1) {
            result.add(line.substring(lastPos + 1, currPos));
            lastPos = currPos;
        }
        result.add(line.substring(lastPos + 1));
        return result.toArray(new String[result.size()]);
    }
}

