/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nz.ac.waikato.cms.gui.core.BasePanel;
import nz.ac.waikato.cms.gui.core.GUIHelper;
import nz.ac.waikato.cms.gui.core.KeyUtils;
import nz.ac.waikato.cms.gui.core.MouseUtils;

public abstract class AbstractChooserPanel<T>
extends BasePanel {
    private static final long serialVersionUID = -824479551072915989L;
    protected AbstractChooserPanel m_Self;
    protected JTextField m_TextSelection;
    protected JPanel m_PanelPrefix;
    protected JLabel m_LabelPrefix;
    protected JLabel m_LabelPrefixSpacer;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonSelection;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected PopupMenuCustomizer m_PopupMenuCustomizer;
    protected boolean m_Editable;
    protected boolean m_InlineEditingEnabled;

    protected AbstractChooserPanel() {
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_ChangeListeners = new HashSet();
        this.m_Editable = true;
        this.m_InlineEditingEnabled = false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelPrefix = new JPanel(new BorderLayout());
        this.m_LabelPrefix = new JLabel("");
        this.m_LabelPrefixSpacer = new JLabel("");
        this.m_PanelPrefix.add((Component)this.m_LabelPrefix, "Center");
        this.m_PanelPrefix.add((Component)this.m_LabelPrefixSpacer, "East");
        this.add((Component)this.m_PanelPrefix, "West");
        this.m_TextSelection = new JTextField(this.getSelectionColumns());
        this.m_TextSelection.setTransferHandler(null);
        this.m_TextSelection.setText(this.getDefaultString());
        this.m_TextSelection.setEditable(false);
        this.m_TextSelection.setPreferredSize(new Dimension(this.m_TextSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height + 4));
        this.m_TextSelection.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick(e) && !AbstractChooserPanel.this.isInlineEditingEnabled()) {
                    e.consume();
                    AbstractChooserPanel.this.choose();
                } else if (MouseUtils.isRightClick(e)) {
                    e.consume();
                    JPopupMenu menu = AbstractChooserPanel.this.getPopupMenu();
                    if (menu != null) {
                        menu.show(AbstractChooserPanel.this.m_TextSelection, e.getX(), e.getY());
                    }
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_TextSelection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (KeyUtils.isCopy(e)) {
                    e.consume();
                    AbstractChooserPanel.this.copyToClipboard();
                } else if (KeyUtils.isPaste(e) && ClipboardHelper.canPasteStringFromClipboard()) {
                    e.consume();
                    AbstractChooserPanel.this.pasteFromClipboard();
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.m_TextSelection.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (AbstractChooserPanel.this.isInlineEditingEnabled()) {
                    AbstractChooserPanel.this.setCurrent(AbstractChooserPanel.this.fromString(AbstractChooserPanel.this.m_TextSelection.getText()));
                }
            }
        });
        this.add((Component)this.m_TextSelection, "Center");
        this.m_PanelButtons = new JPanel(new GridLayout(1, 0));
        this.add((Component)this.m_PanelButtons, "East");
        this.m_ButtonSelection = new JButton("...");
        this.m_ButtonSelection.setPreferredSize(new Dimension(this.m_ButtonSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height));
        this.m_ButtonSelection.addActionListener(e -> this.choose());
        this.m_PanelButtons.add(this.m_ButtonSelection);
        this.updatePreferredSize();
    }

    protected int getSelectionColumns() {
        return 30;
    }

    public void setPrefix(String value) {
        char mnemonic = GUIHelper.getMnemonic(value);
        String caption = GUIHelper.stripMnemonic(value);
        this.m_LabelPrefix.setText(caption);
        if (mnemonic != '\u0000') {
            this.m_LabelPrefix.setDisplayedMnemonic(mnemonic);
        } else {
            this.m_LabelPrefix.setDisplayedMnemonicIndex(-1);
        }
        if (value.length() > 0) {
            this.m_LabelPrefixSpacer.setText(" ");
        } else {
            this.m_LabelPrefixSpacer.setText("");
        }
    }

    public String getPrefix() {
        return this.m_LabelPrefix.getText();
    }

    public JLabel getPrefixLabel() {
        return this.m_LabelPrefix;
    }

    protected String getDefaultString() {
        return "";
    }

    public void setDefault() {
        this.m_TextSelection.setText(this.getDefaultString());
        this.m_TextSelection.setCaretPosition(0);
    }

    protected abstract String toString(T var1);

    public boolean setCurrent(T value) {
        boolean result = true;
        String str = this.getDefaultString();
        if (value != null) {
            try {
                str = this.toString(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                str = this.getDefaultString();
                result = false;
            }
        }
        this.m_TextSelection.setText(str);
        this.m_TextSelection.setCaretPosition(0);
        return result;
    }

    public void fireCurrentValueChanged() {
        this.notifyChangeListeners(new ChangeEvent(this.m_Self));
    }

    protected abstract T fromString(String var1);

    public T getCurrent() {
        return this.fromString(this.m_TextSelection.getText());
    }

    protected void copyToClipboard() {
        if (this.m_TextSelection.getSelectedText() == null) {
            ClipboardHelper.copyToClipboard((String)this.m_TextSelection.getText());
        } else {
            ClipboardHelper.copyToClipboard((String)this.m_TextSelection.getSelectedText());
        }
    }

    protected String getStringFromClipboard() {
        if (this.isEditable()) {
            return ClipboardHelper.pasteStringFromClipboard();
        }
        return null;
    }

    protected void pasteFromClipboard() {
        try {
            int caret = this.m_TextSelection.getCaretPosition();
            String clipboard = this.getStringFromClipboard();
            if (this.isInlineEditingEnabled()) {
                StringBuilder text;
                caret += clipboard.length();
                if (this.m_TextSelection.getSelectedText() == null) {
                    text = new StringBuilder(this.m_TextSelection.getText());
                    text.insert(this.m_TextSelection.getCaretPosition(), clipboard);
                } else {
                    text = new StringBuilder(this.m_TextSelection.getText());
                    text.replace(this.m_TextSelection.getSelectionStart(), this.m_TextSelection.getSelectionEnd(), clipboard);
                }
                this.setCurrent(this.fromString(text.toString()));
            } else {
                this.setCurrent(this.fromString(clipboard));
            }
            if (caret > this.m_TextSelection.getDocument().getLength()) {
                caret = this.m_TextSelection.getDocument().getLength();
            }
            if (this.isInlineEditingEnabled()) {
                try {
                    this.m_TextSelection.setCaretPosition(caret);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.notifyChangeListeners(new ChangeEvent(this.m_Self));
        }
        catch (Exception e) {
            e.printStackTrace();
            GUIHelper.showErrorMessage(this, "Error processing clipboard content:\n" + e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners(ChangeEvent e) {
        Iterator<ChangeListener> iter = this.m_ChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().stateChanged(e);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_ButtonSelection.setEnabled(enabled);
        this.m_TextSelection.setEnabled(enabled);
    }

    public void setEditable(boolean value) {
        this.m_Editable = value;
    }

    public boolean isEditable() {
        return this.m_Editable;
    }

    public void setInlineEditingEnabled(boolean value) {
        this.m_InlineEditingEnabled = value;
        this.m_TextSelection.setEditable(value);
    }

    public boolean isInlineEditingEnabled() {
        return this.m_InlineEditingEnabled;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.m_TextSelection.setToolTipText(text);
    }

    protected abstract T doChoose();

    public void choose() {
        T value = this.doChoose();
        if (this.m_Editable && value != null) {
            this.setCurrent(value);
            this.fireCurrentValueChanged();
        }
    }

    public boolean hasValue() {
        return !this.m_TextSelection.getText().equals(this.getDefaultString());
    }

    protected void updatePreferredSize() {
        if (this.m_LabelPrefix.getText().length() == 0) {
            this.setPreferredSize(new Dimension(this.m_TextSelection.getPreferredSize().width + this.m_ButtonSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height));
        } else {
            this.setPreferredSize(new Dimension(this.m_LabelPrefix.getPreferredSize().width + this.m_LabelPrefixSpacer.getPreferredSize().width + this.m_TextSelection.getPreferredSize().width + this.m_ButtonSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height));
        }
    }

    public void setTextColumns(int value) {
        if (value > 0) {
            this.m_TextSelection.setColumns(value);
        } else {
            System.err.println("Number of columns must be >0 (provided: " + value + ")!");
        }
        this.updatePreferredSize();
    }

    public int getTextColumns() {
        return this.m_TextSelection.getColumns();
    }

    @Override
    public void grabFocus() {
        this.m_TextSelection.grabFocus();
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
        menuitem.setAccelerator(KeyStroke.getKeyStroke("control pressed C"));
        menuitem.addActionListener(e -> this.copyToClipboard());
        result.add(menuitem);
        menuitem = new JMenuItem("Paste", GUIHelper.getIcon("paste.gif"));
        menuitem.setAccelerator(KeyStroke.getKeyStroke("control pressed V"));
        menuitem.setEnabled(this.isEditable() && ClipboardHelper.canPasteStringFromClipboard());
        menuitem.addActionListener(e -> this.pasteFromClipboard());
        result.add(menuitem);
        if (this.m_PopupMenuCustomizer != null) {
            result.addSeparator();
            this.m_PopupMenuCustomizer.customizePopupMenu(this, result);
        }
        return result;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    public void moveChooseButton(boolean left) {
        if (left) {
            this.m_PanelPrefix.add((Component)this.m_PanelButtons, "East");
        } else {
            this.add((Component)this.m_PanelButtons, "East");
        }
    }

    public void cleanUp() {
    }

    public static interface PopupMenuCustomizer {
        public void customizePopupMenu(AbstractChooserPanel var1, JPopupMenu var2);
    }
}

