/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import nz.ac.waikato.cms.gui.core.GUIHelper;

public class BaseButtonWithDropDownMenu
extends JButton {
    private static final long serialVersionUID = 6616758688778479716L;
    public static final String SEPARATOR = "---";
    protected List<JMenuItem> m_MenuItems;
    protected JPopupMenu m_Menu;

    public BaseButtonWithDropDownMenu() {
        super(GUIHelper.getIcon("arrow-head-down.png"));
        this.initialize();
    }

    public BaseButtonWithDropDownMenu(Icon icon) {
        super(icon);
        this.initialize();
    }

    public BaseButtonWithDropDownMenu(String text, Icon icon) {
        super(text, icon);
        this.initialize();
    }

    protected void initialize() {
        this.m_MenuItems = new ArrayList<JMenuItem>();
        this.m_Menu = null;
        this.addActionListener(ae -> this.showMenu());
    }

    public void clearMenu() {
        this.m_MenuItems.clear();
    }

    public void addToMenu(JMenuItem item) {
        this.m_MenuItems.add(item);
    }

    public void addToMenu(Action action) {
        this.m_MenuItems.add(new JMenuItem(action));
    }

    public void addSeparatorToMenu() {
        this.m_MenuItems.add(new JMenuItem(SEPARATOR));
    }

    public void setDropDownMenu(JPopupMenu menu) {
        this.m_Menu = menu;
    }

    public JPopupMenu getDropDownMenu() {
        return this.m_Menu;
    }

    protected void showMenu() {
        JPopupMenu menu;
        if (this.m_Menu != null) {
            menu = this.m_Menu;
        } else {
            menu = new JPopupMenu();
            for (JMenuItem menuitem : this.m_MenuItems) {
                if (menuitem.getText().equals(SEPARATOR)) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(menuitem);
            }
        }
        menu.show(this, 0, this.getHeight());
    }
}

