/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import nz.ac.waikato.cms.gui.core.BaseFrame;
import nz.ac.waikato.cms.gui.core.BasePanel;
import nz.ac.waikato.cms.gui.core.GUIHelper;
import nz.ac.waikato.cms.gui.core.PopupMenuCustomizer;
import nz.ac.waikato.cms.gui.core.PopupMenuProvider;

public class DetachablePanel
extends BasePanel
implements PopupMenuProvider {
    private static final long serialVersionUID = -2818808520522758309L;
    protected BasePanel m_ContentPanel;
    protected PopupMenuCustomizer<DetachablePanel> m_PopupMenuCustomizer;
    protected BaseFrame m_DetachedFrame;
    protected BasePanel m_PanelReattach;
    protected JButton m_ButtonReattach;
    protected String m_FrameTitle;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PopupMenuCustomizer = null;
        this.m_DetachedFrame = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_ContentPanel = new BasePanel(new BorderLayout());
        this.add((Component)this.m_ContentPanel, "Center");
        this.m_PanelReattach = new BasePanel(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(1));
        this.m_PanelReattach.add((Component)panel, "Center");
        this.m_ButtonReattach = new JButton("Reattach");
        this.m_ButtonReattach.addActionListener(e -> this.reattach());
        panel.add(this.m_ButtonReattach);
    }

    public BasePanel getContentPanel() {
        return this.m_ContentPanel;
    }

    public boolean isDetached() {
        return this.m_DetachedFrame != null;
    }

    public void detach() {
        if (this.isDetached()) {
            return;
        }
        this.m_DetachedFrame = new BaseFrame(this.getFrameTitle());
        this.m_DetachedFrame.setDefaultCloseOperation(2);
        this.m_DetachedFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                DetachablePanel.this.reattach();
            }
        });
        this.m_DetachedFrame.getContentPane().setLayout(new BorderLayout());
        this.m_DetachedFrame.getContentPane().add((Component)this.m_ContentPanel, "Center");
        this.m_DetachedFrame.pack();
        this.m_DetachedFrame.setSize(new Dimension(800, 600));
        this.m_DetachedFrame.setLocationRelativeTo(this);
        this.m_DetachedFrame.setVisible(true);
        this.add((Component)this.m_PanelReattach, "Center");
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    public void reattach() {
        if (!this.isDetached()) {
            return;
        }
        this.remove(this.m_PanelReattach);
        this.add((Component)this.m_ContentPanel, "Center");
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
        this.m_DetachedFrame.dispose();
        this.m_DetachedFrame = null;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer<DetachablePanel> value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer<DetachablePanel> getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        if (this.isDetached()) {
            JMenuItem menuitem = new JMenuItem("Reattach", GUIHelper.getIcon("minimize.png"));
            menuitem.addActionListener(e -> this.reattach());
            result.add(menuitem);
        } else {
            JMenuItem menuitem = new JMenuItem("Detach", GUIHelper.getIcon("maximize.png"));
            menuitem.addActionListener(e -> this.detach());
            result.add(menuitem);
        }
        return result;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu result = this.createPopupMenu();
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu(this, result);
        }
        return result;
    }

    public void setFrameTitle(String value) {
        this.m_FrameTitle = value;
    }

    public String getFrameTitle() {
        return this.m_FrameTitle;
    }

    public void cleanUp() {
        if (this.isDetached()) {
            this.reattach();
        }
    }
}

