/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.core;

import java.awt.Component;
import java.awt.Desktop;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.JOptionPane;
import nz.ac.waikato.cms.core.OS;

public class BrowserHelper {
    public static final String[] LINUX_BROWSERS = new String[]{"firefox", "google-chrome", "opera", "konqueror", "epiphany", "mozilla", "netscape"};

    public static synchronized String openURL(String url) {
        return BrowserHelper.openURL(null, url);
    }

    public static synchronized String openURL(Component parent, String url) {
        return BrowserHelper.openURL(parent, url, true);
    }

    public static synchronized String openURL(Component parent, String url, boolean showDialog) {
        String result = null;
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                System.err.println("Desktop or browse action not supported, using fallback to determine browser.");
                if (OS.isMac()) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                } else if (OS.isWindows()) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    String browser = null;
                    for (int count = 0; count < LINUX_BROWSERS.length; ++count) {
                        if (Runtime.getRuntime().exec(new String[]{"which", LINUX_BROWSERS[count]}).waitFor() != 0) continue;
                        browser = LINUX_BROWSERS[count];
                        break;
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
        }
        catch (Exception e) {
            result = "Error attempting to launch web browser:\n" + e.getMessage();
            if (showDialog) {
                JOptionPane.showMessageDialog(parent, result, "Error", 0);
            }
            System.err.println(result);
        }
        return result;
    }

    public static synchronized String openURL(Component parent, String cmd, String url, boolean showDialog) {
        String result = null;
        try {
            Runtime.getRuntime().exec(cmd + " " + url);
        }
        catch (Exception e) {
            result = "Error attempting to launch web browser '" + cmd + "':\n" + e.getMessage();
            if (showDialog) {
                JOptionPane.showMessageDialog(parent, result, "Error", 0);
            }
            System.err.println(result);
        }
        return result;
    }
}

