/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.awt.HeadlessException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nz.ac.waikato.cms.locator.ClassCache;
import nz.ac.waikato.cms.locator.ClassCompare;
import nz.ac.waikato.cms.locator.ClassUtils;
import nz.ac.waikato.cms.locator.LoggingHelper;
import nz.ac.waikato.cms.locator.StringCompare;

public class ClassLocator
implements Serializable {
    private static final long serialVersionUID = 6443115424919701746L;
    protected static Map<String, Boolean> m_CheckSubClass = new HashMap<String, Boolean>();
    protected static Map<String, Boolean> m_CheckInterface = new HashMap<String, Boolean>();
    protected transient Logger m_Logger;
    protected HashMap<String, List<String>> m_CacheNames;
    protected HashMap<String, List<Class>> m_CacheClasses;
    protected HashSet<String> m_BlackListed;
    protected ClassCache m_Cache;
    protected boolean m_OnlyDefaultConstructor;
    protected boolean m_OnlySerializable;
    protected static ClassLocator m_Singleton;

    protected ClassLocator() {
        this.initCache();
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    public void setOnlyDefaultConstructor(boolean value) {
        this.m_OnlyDefaultConstructor = value;
    }

    public boolean isOnlyDefaultConstructor() {
        return this.m_OnlyDefaultConstructor;
    }

    public void setOnlySerializable(boolean value) {
        this.m_OnlySerializable = value;
    }

    public boolean isOnlySerializable() {
        return this.m_OnlySerializable;
    }

    public List<String> findNames(String classname, String[] pkgnames) {
        ArrayList<String> result = new ArrayList();
        try {
            Class<?> cls = Class.forName(classname);
            result = this.findNames(cls, pkgnames);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + classname + "'/" + ClassUtils.arrayToString(pkgnames) + " (findNames):", t);
        }
        return result;
    }

    public List<Class> findClasses(String classname, String[] pkgnames) {
        ArrayList<Class> result = new ArrayList();
        try {
            Class<?> cls = Class.forName(classname);
            result = this.findClasses(cls, pkgnames);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + classname + "'/" + ClassUtils.arrayToString(pkgnames) + " (findClasses):", t);
        }
        return result;
    }

    public List<String> findNames(Class cls, String[] pkgnames) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < pkgnames.length; ++i) {
            names.addAll(this.findNamesInPackage(cls, pkgnames[i]));
        }
        result.addAll(names);
        Collections.sort(result, new StringCompare());
        return result;
    }

    public List<Class> findClasses(Class cls, String[] pkgnames) {
        ArrayList<Class> result = new ArrayList<Class>();
        HashSet<Class> classes = new HashSet<Class>();
        for (int i = 0; i < pkgnames.length; ++i) {
            classes.addAll(this.findClassesInPackage(cls, pkgnames[i]));
        }
        result.addAll(classes);
        Collections.sort(result, new ClassCompare());
        return result;
    }

    public List<String> findNamesInPackage(String classname, String pkgname) {
        ArrayList<String> result = new ArrayList();
        try {
            Class<?> cls = Class.forName(classname);
            result = this.findNamesInPackage(cls, pkgname);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + classname + "'/" + pkgname + " (findNamesInPackage):", t);
        }
        return result;
    }

    public List<Class> findClassesInPackage(String classname, String pkgname) {
        ArrayList<Class> result = new ArrayList();
        try {
            Class<?> cls = Class.forName(classname);
            result = this.findClassesInPackage(cls, pkgname);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + classname + "'/" + pkgname + " (findClassesInPackage):", t);
        }
        return result;
    }

    public List<String> findNamesInPackage(Class cls, String pkgname) {
        List<String> result = this.getNameCache(cls, pkgname);
        if (result == null) {
            this.getLogger().info("Searching for '" + cls.getName() + "' in '" + pkgname + "':");
            result = new ArrayList<String>();
            ArrayList<Class> classes = new ArrayList<Class>();
            if (this.m_Cache.getClassnames(pkgname) != null) {
                result.addAll(this.m_Cache.getClassnames(pkgname));
            }
            int i = 0;
            while (i < result.size()) {
                try {
                    if (result.get(i).indexOf(36) > -1) {
                        result.remove(i);
                        continue;
                    }
                    if (this.isBlacklisted(result.get(i))) {
                        result.remove(i);
                        continue;
                    }
                    Class<?> clsNew = Class.forName(result.get(i));
                    if (Modifier.isAbstract(clsNew.getModifiers())) {
                        this.m_Cache.remove(result.get(i));
                        result.remove(i);
                        continue;
                    }
                    if (this.m_OnlyDefaultConstructor) {
                        try {
                            clsNew.getConstructor(new Class[0]);
                        }
                        catch (Exception e) {
                            this.m_Cache.remove(result.get(i));
                            result.remove(i);
                            continue;
                        }
                    }
                    if (this.m_OnlySerializable && !ClassLocator.hasInterface(Serializable.class, clsNew)) {
                        this.m_Cache.remove(result.get(i));
                        result.remove(i);
                        continue;
                    }
                    if (cls.isInterface() && !ClassLocator.hasInterface(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    if (!cls.isInterface() && !ClassLocator.isSubclass(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    classes.add(clsNew);
                    ++i;
                }
                catch (Throwable t) {
                    if (t.getCause() != null && t.getCause() instanceof HeadlessException) {
                        this.getLogger().warning("Cannot instantiate '" + result.get(i) + "' in headless environment - skipped.");
                    } else {
                        this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + result.get(i) + "' (find):", t);
                    }
                    this.blacklist(result.get(i));
                    result.remove(i);
                }
            }
            if (result.size() != classes.size()) {
                throw new IllegalStateException("Differing number of classnames and classes: " + result.size() + " != " + classes.size());
            }
            Collections.sort(result, new StringCompare());
            Collections.sort(classes, new ClassCompare());
            this.addCache(cls, pkgname, result, classes);
        }
        return result;
    }

    public List<Class> findClassesInPackage(Class cls, String pkgname) {
        this.findNamesInPackage(cls, pkgname);
        return this.getClassCache(cls, pkgname);
    }

    public List<String> findPackages() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> packages = this.m_Cache.packages();
        while (packages.hasNext()) {
            result.add(packages.next());
        }
        Collections.sort(result, new StringCompare());
        return result;
    }

    protected ClassCache newClassCache() {
        return new ClassCache();
    }

    protected void initCache() {
        if (this.m_CacheNames == null) {
            this.m_CacheNames = new HashMap();
        }
        if (this.m_CacheClasses == null) {
            this.m_CacheClasses = new HashMap();
        }
        if (this.m_BlackListed == null) {
            this.m_BlackListed = new HashSet();
        }
        if (this.m_Cache == null) {
            this.m_Cache = this.newClassCache();
        }
    }

    protected void addCache(Class cls, String pkgname, List<String> classnames, List<Class> classes) {
        this.m_CacheNames.put(cls.getName() + "-" + pkgname, classnames);
        this.m_CacheClasses.put(cls.getName() + "-" + pkgname, classes);
    }

    protected List<String> getNameCache(Class cls, String pkgname) {
        return this.m_CacheNames.get(cls.getName() + "-" + pkgname);
    }

    protected List<Class> getClassCache(Class cls, String pkgname) {
        return this.m_CacheClasses.get(cls.getName() + "-" + pkgname);
    }

    protected void blacklist(String classname) {
        this.m_BlackListed.add(classname);
    }

    public boolean isBlacklisted(String classname) {
        return this.m_BlackListed.contains(classname);
    }

    public ClassCache getCache() {
        return this.m_Cache;
    }

    public static synchronized ClassLocator getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ClassLocator();
        }
        return m_Singleton;
    }

    public static boolean isSubclass(String superclass, String otherclass) {
        String key = superclass + "-" + otherclass;
        if (m_CheckSubClass.containsKey(key)) {
            return m_CheckSubClass.get(key);
        }
        try {
            return ClassLocator.isSubclass(Class.forName(superclass), Class.forName(otherclass));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isSubclass(Class superclass, Class otherclass) {
        boolean result;
        String key = superclass.getName() + "-" + otherclass.getName();
        if (m_CheckSubClass.containsKey(key)) {
            return m_CheckSubClass.get(key);
        }
        Class currentclass = otherclass;
        do {
            result = currentclass.equals(superclass);
            if (currentclass.equals(Object.class) || currentclass.getSuperclass() == null) break;
            if (result) continue;
            currentclass = currentclass.getSuperclass();
        } while (!result);
        m_CheckSubClass.put(key, result);
        return result;
    }

    public static boolean hasInterface(String intf, String cls) {
        String key = intf + "-" + cls;
        if (m_CheckInterface.containsKey(key)) {
            return m_CheckInterface.get(key);
        }
        try {
            return ClassLocator.hasInterface(Class.forName(intf), Class.forName(cls));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasInterface(Class intf, Class cls) {
        String key = intf.getName() + "-" + cls.getName();
        if (m_CheckInterface.containsKey(key)) {
            return m_CheckInterface.get(key);
        }
        boolean result = intf.isAssignableFrom(cls);
        m_CheckInterface.put(key, result);
        return result;
    }

    public static boolean matches(String superclassOrIntf, String otherclass) {
        return ClassLocator.isSubclass(superclassOrIntf, otherclass) || ClassLocator.hasInterface(superclassOrIntf, otherclass);
    }

    public static boolean matches(Class superclassOrIntf, Class otherclass) {
        return ClassLocator.isSubclass(superclassOrIntf, otherclass) || ClassLocator.hasInterface(superclassOrIntf, otherclass);
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("packages")) {
            List<String> list = ClassLocator.getSingleton().findPackages();
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
        } else if (args.length == 2) {
            ArrayList<String> packages = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(args[1], ",");
            while (tok.hasMoreTokens()) {
                packages.add(tok.nextToken());
            }
            List<String> list = ClassLocator.getSingleton().findNames(args[0], packages.toArray(new String[packages.size()]));
            System.out.println("Searching for '" + args[0] + "' in '" + args[1] + "':\n  " + list.size() + " found.");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("  " + (i + 1) + ". " + list.get(i));
            }
        } else {
            System.out.println("\nUsage:");
            System.out.println(ClassLocator.class.getName() + " packages");
            System.out.println("\tlists all packages in the classpath");
            System.out.println(ClassLocator.class.getName() + " <classname> <packagename(s)>");
            System.out.println("\tlists classes derived from/implementing 'classname' that");
            System.out.println("\tcan be found in 'packagename(s)' (comma-separated list)");
            System.out.println();
            System.exit(1);
        }
    }
}

