/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import nz.ac.waikato.cms.locator.ClassPathTraversal;
import nz.ac.waikato.cms.locator.ClassTraversal;
import nz.ac.waikato.cms.locator.LoggingHelper;
import nz.ac.waikato.cms.locator.TraversalListener;

public class ClassCache
implements Serializable {
    private static final long serialVersionUID = -2973185784363491578L;
    protected transient Logger m_Logger;
    protected HashMap<String, HashSet<String>> m_NameCache;

    public ClassCache() {
        this.initialize(new ClassPathTraversal());
    }

    public ClassCache(ClassTraversal traversal) {
        this.initialize(traversal == null ? new ClassPathTraversal() : traversal);
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    public boolean remove(String classname) {
        String pkgname = ClassPathTraversal.extractPackage(classname = ClassPathTraversal.cleanUp(classname));
        HashSet<String> names = this.m_NameCache.get(pkgname);
        if (names != null) {
            return names.remove(classname);
        }
        return false;
    }

    public Iterator<String> packages() {
        return this.m_NameCache.keySet().iterator();
    }

    public HashSet<String> getClassnames(String pkgname) {
        if (this.m_NameCache.containsKey(pkgname)) {
            return this.m_NameCache.get(pkgname);
        }
        return new HashSet<String>();
    }

    protected void initialize(ClassTraversal traversal) {
        Listener listener = new Listener();
        traversal.traverse(listener);
        this.m_NameCache = listener.getNameCache();
    }

    public boolean isEmpty() {
        return this.m_NameCache == null || this.m_NameCache.isEmpty();
    }

    public static void main(String[] args) {
        ClassCache cache = new ClassCache();
        Iterator<String> packages = cache.packages();
        ArrayList<String> sorted = new ArrayList<String>();
        while (packages.hasNext()) {
            sorted.add(packages.next());
        }
        Collections.sort(sorted);
        for (String key : sorted) {
            System.out.println(key + ": " + cache.getClassnames(key).size());
        }
    }

    public static class Listener
    implements TraversalListener {
        protected HashMap<String, HashSet<String>> m_NameCache = new HashMap();
        protected transient Logger m_Logger;

        public synchronized Logger getLogger() {
            if (this.m_Logger == null) {
                this.m_Logger = Logger.getLogger(this.getClass().getName());
                this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
            }
            return this.m_Logger;
        }

        @Override
        public void traversing(String classname, URL classPathPart) {
            String pkgname = ClassPathTraversal.extractPackage(classname);
            if (!this.m_NameCache.containsKey(pkgname)) {
                this.m_NameCache.put(pkgname, new HashSet());
            }
            HashSet<String> names = this.m_NameCache.get(pkgname);
            names.add(classname);
        }

        public HashMap<String, HashSet<String>> getNameCache() {
            return this.m_NameCache;
        }
    }
}

